/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.actors.deadlock;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.metaborg.util.collection.MultiSet;
import org.metaborg.util.functions.Action1;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class ChandyMisraHaas<P> {
    private static final ILogger logger = LoggerUtils.logger(ChandyMisraHaas.class);
    private final Host<P> self;
    private final Action1<Set<P>> deadlockHandler;
    private State state;
    private final MultiSet.Transient<P> latest;
    private final Map<P, P> engager;
    private final MultiSet.Transient<P> num;
    private Map<P, Set<P>> wait;

    public ChandyMisraHaas(Host<P> self, Action1<Set<P>> deadlockHandler) {
        this.self = self;
        this.deadlockHandler = deadlockHandler;
        this.state = State.EXECUTING;
        this.latest = MultiSet.Transient.of();
        this.engager = new HashMap<P, P>();
        this.num = MultiSet.Transient.of();
        this.wait = new HashMap<P, Set<P>>();
    }

    public boolean idle() {
        if (this.state.equals((Object)State.IDLE)) {
            return false;
        }
        logger.debug("{} idle", this.self);
        P i = this.self.process();
        this.state = State.IDLE;
        int c = this.latest.add(i, 1) + 1;
        this.wait.computeIfAbsent(i, __ -> new HashSet()).add(i);
        Set<P> S2 = this.self.dependentSet();
        for (P j : S2) {
            this.self.query(j, i, c);
        }
        this.num.set(i, S2.size());
        return true;
    }

    public boolean exec() {
        if (this.state.equals((Object)State.EXECUTING)) {
            return false;
        }
        logger.debug("{} exec", this.self);
        P k = this.self.process();
        this.state = State.EXECUTING;
        this.wait = new HashMap<P, Set<P>>();
        return true;
    }

    public void query(P i, int m, P j) {
        if (this.state.equals((Object)State.EXECUTING)) {
            return;
        }
        logger.debug("{} query {}.{} from {}", this.self, i, m, j);
        P k = this.self.process();
        int c = this.latest.count(i);
        if (m > c) {
            this.latest.set(i, m);
            this.engager.put(i, j);
            this.wait.computeIfAbsent(i, __ -> new HashSet()).add(k);
            Set<P> S2 = this.self.dependentSet();
            for (P r : S2) {
                this.self.query(r, i, m);
            }
            this.num.set(i, S2.size());
        } else if (this.wait.containsKey(i) && m == c) {
            this.self.assertOnActorThread();
            this.self.reply(j, i, m, this.wait.put(i, new HashSet()));
        }
    }

    public void reply(P i, int m, Set<P> R2) {
        if (this.state.equals((Object)State.EXECUTING)) {
            return;
        }
        logger.debug("{} reply {}.{} from {}", this.self, i, m, R2);
        P k = this.self.process();
        if (m == this.latest.count(i) && this.wait.containsKey(i)) {
            Set units = this.wait.computeIfAbsent(i, __ -> new HashSet());
            for (P r : R2) {
                units.add(r);
            }
            if (this.num.remove(i, 1) == 1) {
                this.self.assertOnActorThread();
                Set Q2 = this.wait.put(i, new HashSet());
                if (i.equals(k)) {
                    logger.debug("{} deadlocked with {}", this.self, Q2);
                    this.deadlockHandler.apply(Q2);
                } else {
                    P j = this.engager.get(i);
                    this.self.reply(j, i, m, Q2);
                }
            }
        }
    }

    public static interface Host<P> {
        public P process();

        public Set<P> dependentSet();

        public void query(P var1, P var2, int var3);

        public void reply(P var1, P var2, int var3, Set<P> var4);

        public void assertOnActorThread();
    }

    static enum State {
        IDLE,
        EXECUTING;

    }
}

