/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.util.graph.igraph;

import java.util.Set;
import mb.nabl2.util.graph.alg.misc.CollectionsFactory;
import mb.nabl2.util.graph.alg.misc.IMultiLookup;
import mb.nabl2.util.graph.alg.misc.memory.IMemoryView;
import mb.nabl2.util.graph.igraph.IBiDirectionalGraphDataSource;
import mb.nabl2.util.graph.igraph.IGraphDataSource;
import mb.nabl2.util.graph.igraph.IGraphObserver;

public class IBiDirectionalWrapper<V>
implements IBiDirectionalGraphDataSource<V>,
IGraphObserver<V> {
    private IGraphDataSource<V> wrappedDataSource;
    private IMultiLookup<V, V> incomingEdges;

    public IBiDirectionalWrapper(IGraphDataSource<V> gds) {
        this.wrappedDataSource = gds;
        this.incomingEdges = CollectionsFactory.createMultiLookup();
        if (gds.getAllNodes() != null) {
            for (V source : gds.getAllNodes()) {
                IMemoryView<V> targets = gds.getTargetNodes(source);
                for (V target : targets.distinctValues()) {
                    int count = targets.getCount(target);
                    int i = 0;
                    while (i < count) {
                        this.edgeInserted(source, target);
                        ++i;
                    }
                }
            }
        }
        gds.attachAsFirstObserver(this);
    }

    @Override
    public void attachObserver(IGraphObserver<V> observer) {
        this.wrappedDataSource.attachObserver(observer);
    }

    @Override
    public void attachAsFirstObserver(IGraphObserver<V> observer) {
        this.wrappedDataSource.attachAsFirstObserver(observer);
    }

    @Override
    public void detachObserver(IGraphObserver<V> observer) {
        this.wrappedDataSource.detachObserver(observer);
    }

    @Override
    public Set<V> getAllNodes() {
        return this.wrappedDataSource.getAllNodes();
    }

    @Override
    public IMemoryView<V> getTargetNodes(V source) {
        return this.wrappedDataSource.getTargetNodes(source);
    }

    @Override
    public IMemoryView<V> getSourceNodes(V target) {
        return this.incomingEdges.lookupOrEmpty(target);
    }

    @Override
    public void edgeInserted(V source, V target) {
        this.incomingEdges.addPair(target, source);
    }

    @Override
    public void edgeDeleted(V source, V target) {
        this.incomingEdges.removePair(target, source);
    }

    @Override
    public void nodeInserted(V n) {
    }

    @Override
    public void nodeDeleted(V node) {
    }

    public String toString() {
        return this.wrappedDataSource.toString();
    }
}

