/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.matching;

import io.usethesource.capsule.Set;
import java.util.Objects;
import java.util.Optional;
import mb.nabl2.terms.IAttachments;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.Terms;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.Pattern;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.unification.u.IUnifier;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.functions.Action2;
import org.metaborg.util.functions.Function0;
import org.metaborg.util.functions.Function1;

public final class IntPattern
extends Pattern {
    private static final long serialVersionUID = 1L;
    private final int value;

    IntPattern(int value, IAttachments attachments) {
        super(attachments);
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public Set<ITermVar> getVars() {
        return CapsuleUtil.immutableSet();
    }

    @Override
    public boolean isConstructed() {
        return true;
    }

    @Override
    protected boolean matchTerm(ITerm term, ISubstitution.Transient subst, IUnifier.Immutable unifier, Pattern.Eqs eqs) {
        return unifier.findTerm(term).match(Terms.cases().integer(intTerm -> {
            if (intTerm.getValue() == this.value) {
                return true;
            }
            return false;
        }).var(v -> {
            eqs.add((ITermVar)v, this);
            return true;
        }).otherwise(t -> false));
    }

    @Override
    public IntPattern apply(IRenaming subst) {
        return this;
    }

    @Override
    public Pattern eliminateWld(Function0<ITermVar> fresh) {
        return this;
    }

    @Override
    protected ITerm asTerm(Action2<ITermVar, ITerm> equalities, Function1<Optional<ITermVar>, ITermVar> fresh) {
        return TermBuild.B.newInt(this.value, this.getAttachments());
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntPattern that = (IntPattern)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

