/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.matching;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;
import mb.nabl2.terms.IApplTerm;
import mb.nabl2.terms.IConsTerm;
import mb.nabl2.terms.IIntTerm;
import mb.nabl2.terms.IListTerm;
import mb.nabl2.terms.INilTerm;
import mb.nabl2.terms.IStringTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.ListTerms;
import mb.nabl2.terms.Terms;
import mb.nabl2.terms.unification.Unifiers;
import mb.nabl2.terms.unification.u.IUnifier;
import org.metaborg.util.functions.CheckedFunction1;
import org.metaborg.util.functions.CheckedFunction2;
import org.metaborg.util.functions.CheckedFunction3;
import org.metaborg.util.functions.CheckedFunction4;

public class CheckedTermMatch {
    public static final CM CM = new CM();

    public static class CM {
        public <E extends Throwable> ICheckedMatcher<ITerm, E> term() {
            return (term, unifier) -> Optional.of(term);
        }

        public <R, E extends Throwable> ICheckedMatcher<R, E> term(CheckedFunction1<? super ITerm, R, ? extends E> f) {
            return (term, unifier) -> Optional.of(f.apply(term));
        }

        public <R, E extends Throwable> ICheckedMatcher<R, E> term(ITerm.CheckedCases<Optional<R>, E> cases) {
            return (term, unifier) -> (Optional)unifier.findTerm(term).matchOrThrow(cases);
        }

        public <R, E extends Throwable> ICheckedMatcher<R, E> appl(CheckedFunction1<? super IApplTerm, R, ? extends E> f) {
            return (term, unifier) -> unifier.findTerm(term).matchOrThrow(Terms.checkedCases(appl -> Optional.of(f.apply((IApplTerm)appl)), this::empty, this::empty, this::empty, this::empty, this::empty));
        }

        public <R, E extends Throwable> ICheckedMatcher<R, E> appl0(String op, CheckedFunction1<? super IApplTerm, R, ? extends E> f) {
            return (term, unifier) -> unifier.findTerm(term).matchOrThrow(Terms.checkedCases(appl -> {
                if (appl.getArity() != 0 || !op.equals(appl.getOp())) {
                    return Optional.empty();
                }
                return Optional.of(f.apply((IApplTerm)appl));
            }, this::empty, this::empty, this::empty, this::empty, this::empty));
        }

        public <T, R, E extends Throwable> ICheckedMatcher<R, E> appl1(String op, ICheckedMatcher<? extends T, ? extends E> m, CheckedFunction2<? super IApplTerm, ? super T, R, ? extends E> f) {
            return (term, unifier) -> unifier.findTerm(term).matchOrThrow(Terms.checkedCases(appl -> {
                if (appl.getArity() != 1 || !op.equals(appl.getOp())) {
                    return Optional.empty();
                }
                Optional o1 = m.matchOrThrow(appl.getArgs().get(0), unifier);
                if (!o1.isPresent()) {
                    return Optional.empty();
                }
                Object t = o1.get();
                return Optional.of(f.apply((IApplTerm)appl, (Object)t));
            }, this::empty, this::empty, this::empty, this::empty, this::empty));
        }

        public <T1, T2, R, E extends Throwable> ICheckedMatcher<R, E> appl2(String op, ICheckedMatcher<? extends T1, ? extends E> m1, ICheckedMatcher<? extends T2, ? extends E> m2, CheckedFunction3<? super IApplTerm, ? super T1, ? super T2, R, ? extends E> f) {
            return (term, unifier) -> unifier.findTerm(term).matchOrThrow(Terms.checkedCases(appl -> {
                if (appl.getArity() != 2 || !op.equals(appl.getOp())) {
                    return Optional.empty();
                }
                Optional o1 = m1.matchOrThrow(appl.getArgs().get(0), unifier);
                if (!o1.isPresent()) {
                    return Optional.empty();
                }
                Object t1 = o1.get();
                Optional o2 = m2.matchOrThrow(appl.getArgs().get(1), unifier);
                if (!o2.isPresent()) {
                    return Optional.empty();
                }
                Object t2 = o2.get();
                return Optional.of(f.apply((IApplTerm)appl, (Object)t1, (Object)t2));
            }, this::empty, this::empty, this::empty, this::empty, this::empty));
        }

        public <T1, T2, T3, R, E extends Throwable> ICheckedMatcher<R, E> appl3(String op, ICheckedMatcher<? extends T1, ? extends E> m1, ICheckedMatcher<? extends T2, ? extends E> m2, ICheckedMatcher<? extends T3, ? extends E> m3, CheckedFunction4<? super IApplTerm, ? super T1, ? super T2, ? super T3, R, ? extends E> f) {
            return (term, unifier) -> unifier.findTerm(term).matchOrThrow(Terms.checkedCases(appl -> {
                if (appl.getArity() != 3 || !op.equals(appl.getOp())) {
                    return Optional.empty();
                }
                Optional o1 = m1.matchOrThrow(appl.getArgs().get(0), unifier);
                if (!o1.isPresent()) {
                    return Optional.empty();
                }
                Object t1 = o1.get();
                Optional o2 = m2.matchOrThrow(appl.getArgs().get(1), unifier);
                if (!o2.isPresent()) {
                    return Optional.empty();
                }
                Object t2 = o2.get();
                Optional o3 = m3.matchOrThrow(appl.getArgs().get(2), unifier);
                if (!o3.isPresent()) {
                    return Optional.empty();
                }
                Object t3 = o3.get();
                return Optional.of(f.apply((IApplTerm)appl, (Object)t1, (Object)t2, (Object)t3));
            }, this::empty, this::empty, this::empty, this::empty, this::empty));
        }

        public <R, E extends Throwable> ICheckedMatcher<R, E> list(CheckedFunction1<? super IListTerm, R, ? extends E> f) {
            CheckedFunction1 g = list -> Optional.of(f.apply((IListTerm)list));
            return (term, unifier) -> unifier.findTerm(term).matchOrThrow(Terms.checkedCases(this::empty, g, this::empty, this::empty, this::empty, g));
        }

        public <R, E extends Throwable> ICheckedMatcher<R, E> list(IListTerm.CheckedCases<Optional<R>, E> cases) {
            CheckedFunction1 g = list -> (Optional)list.matchOrThrow(cases);
            return (term, unifier) -> unifier.findTerm(term).matchOrThrow(Terms.checkedCases(this::empty, g, this::empty, this::empty, this::empty, g));
        }

        public <T, R, E extends Throwable> ICheckedMatcher<R, E> listElems(ICheckedMatcher<? extends T, ? extends E> m, CheckedFunction2<? super IListTerm, Iterable<T>, R, ? extends E> f) {
            return (term, unifier) -> unifier.findTerm(term).matchOrThrow(Terms.checkedCases(this::empty, list -> {
                ArrayList ts = new ArrayList();
                for (ITerm t : ListTerms.iterable(list)) {
                    Optional o = m.matchOrThrow(t, unifier);
                    if (!o.isPresent()) {
                        return Optional.empty();
                    }
                    ts.add(o.get());
                }
                return Optional.of(f.apply((IListTerm)list, ts));
            }, this::empty, this::empty, this::empty, this::empty));
        }

        public <R, E extends Throwable> ICheckedMatcher<R, E> cons(CheckedFunction1<? super IConsTerm, R, ? extends E> f) {
            return (term, unifier) -> unifier.findTerm(term).matchOrThrow(Terms.checkedCases(this::empty, list -> list.matchOrThrow(ListTerms.checkedCases(cons -> Optional.of(f.apply((IConsTerm)cons)), nil -> Optional.empty(), var -> Optional.empty())), this::empty, this::empty, this::empty, this::empty));
        }

        public <R, E extends Throwable> ICheckedMatcher<R, E> nil(CheckedFunction1<? super INilTerm, R, ? extends E> f) {
            return (term, unifier) -> unifier.findTerm(term).matchOrThrow(Terms.checkedCases(this::empty, list -> list.matchOrThrow(ListTerms.checkedCases(cons -> Optional.empty(), nil -> Optional.of(f.apply((INilTerm)nil)), var -> Optional.empty())), this::empty, this::empty, this::empty, this::empty));
        }

        public <R, E extends Throwable> ICheckedMatcher<R, E> integer(CheckedFunction1<IIntTerm, R, ? extends E> f) {
            return (term, unifier) -> unifier.findTerm(term).matchOrThrow(Terms.checkedCases(this::empty, this::empty, this::empty, string -> Optional.of(f.apply((IIntTerm)string)), this::empty, this::empty));
        }

        public <R, E extends Throwable> ICheckedMatcher<R, E> string(CheckedFunction1<IStringTerm, R, ? extends E> f) {
            return (term, unifier) -> unifier.findTerm(term).matchOrThrow(Terms.checkedCases(this::empty, this::empty, string -> Optional.of(f.apply((IStringTerm)string)), this::empty, this::empty, this::empty));
        }

        public <R, E extends Throwable> ICheckedMatcher<R, E> var(CheckedFunction1<? super ITermVar, R, ? extends E> f) {
            return (term, unifier) -> unifier.findTerm(term).matchOrThrow(Terms.checkedCases(this::empty, list -> list.matchOrThrow(ListTerms.checkedCases(cons -> Optional.empty(), nil -> Optional.empty(), var -> Optional.of(f.apply((ITermVar)var)))), this::empty, this::empty, this::empty, var -> Optional.of(f.apply((ITermVar)var))));
        }

        @SafeVarargs
        public final <T, E extends Throwable> ICheckedMatcher<T, E> cases(ICheckedMatcher<? extends T, ? extends E> ... matchers) {
            return (term, unifier) -> {
                ICheckedMatcher[] iCheckedMatcherArray2 = matchers;
                int n = matchers.length;
                int n2 = 0;
                while (n2 < n) {
                    ICheckedMatcher matcher = iCheckedMatcherArray2[n2];
                    Optional result = matcher.matchOrThrow(term, unifier);
                    if (result.isPresent()) {
                        return Optional.of(result.get());
                    }
                    ++n2;
                }
                return Optional.empty();
            };
        }

        private <T> Optional<T> empty(ITerm term) {
            return Optional.empty();
        }
    }

    @FunctionalInterface
    public static interface ICheckedMatcher<T, E extends Throwable> {
        public Optional<T> matchOrThrow(ITerm var1, IUnifier var2) throws E;

        default public Optional<T> matchOrThrow(ITerm term) throws E {
            return this.matchOrThrow(term, Unifiers.Immutable.of());
        }

        default public <R> ICheckedMatcher<R, E> map(Function<T, R> fun) {
            return (term, unifier) -> this.matchOrThrow(term, unifier).map(fun);
        }

        default public <R> ICheckedMatcher<R, E> flatMap(Function<T, Optional<R>> fun) {
            return (term, unifier) -> this.matchOrThrow(term, unifier).flatMap(fun);
        }
    }
}

