/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.build;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import mb.nabl2.terms.IApplTerm;
import mb.nabl2.terms.IAttachments;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.AAppl4Term;
import mb.nabl2.terms.build.AbstractApplTerm;
import mb.nabl2.terms.build.AbstractTerm;

final class Appl4Term
extends AAppl4Term
implements Serializable {
    private final IAttachments attachments;
    private final String op;
    private final ITerm arg0;
    private final ITerm arg1;
    private final ITerm arg2;
    private final ITerm arg3;
    private static final long serialVersionUID = 42L;

    private Appl4Term(String op, ITerm arg0, ITerm arg1, ITerm arg2, ITerm arg3) {
        this.op = Objects.requireNonNull(op, "op");
        this.arg0 = Objects.requireNonNull(arg0, "arg0");
        this.arg1 = Objects.requireNonNull(arg1, "arg1");
        this.arg2 = Objects.requireNonNull(arg2, "arg2");
        this.arg3 = Objects.requireNonNull(arg3, "arg3");
        this.attachments = Objects.requireNonNull(super.getAttachments(), "attachments");
    }

    private Appl4Term(Builder builder) {
        this.op = builder.op;
        this.arg0 = builder.arg0;
        this.arg1 = builder.arg1;
        this.arg2 = builder.arg2;
        this.arg3 = builder.arg3;
        this.attachments = builder.attachments != null ? builder.attachments : Objects.requireNonNull(super.getAttachments(), "attachments");
    }

    private Appl4Term(IAttachments attachments, String op, ITerm arg0, ITerm arg1, ITerm arg2, ITerm arg3) {
        this.attachments = attachments;
        this.op = op;
        this.arg0 = arg0;
        this.arg1 = arg1;
        this.arg2 = arg2;
        this.arg3 = arg3;
    }

    @Override
    public IAttachments getAttachments() {
        return this.attachments;
    }

    @Override
    public String getOp() {
        return this.op;
    }

    @Override
    public ITerm getArg0() {
        return this.arg0;
    }

    @Override
    public ITerm getArg1() {
        return this.arg1;
    }

    @Override
    public ITerm getArg2() {
        return this.arg2;
    }

    @Override
    public ITerm getArg3() {
        return this.arg3;
    }

    @Override
    public final Appl4Term withAttachments(IAttachments value) {
        if (this.attachments == value) {
            return this;
        }
        IAttachments newValue = Objects.requireNonNull(value, "attachments");
        return Appl4Term.validate(new Appl4Term(newValue, this.op, this.arg0, this.arg1, this.arg2, this.arg3));
    }

    public final Appl4Term withOp(String value) {
        String newValue = Objects.requireNonNull(value, "op");
        if (this.op.equals(newValue)) {
            return this;
        }
        return Appl4Term.validate(new Appl4Term(this.attachments, newValue, this.arg0, this.arg1, this.arg2, this.arg3));
    }

    public final Appl4Term withArg0(ITerm value) {
        if (this.arg0 == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "arg0");
        return Appl4Term.validate(new Appl4Term(this.attachments, this.op, newValue, this.arg1, this.arg2, this.arg3));
    }

    public final Appl4Term withArg1(ITerm value) {
        if (this.arg1 == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "arg1");
        return Appl4Term.validate(new Appl4Term(this.attachments, this.op, this.arg0, newValue, this.arg2, this.arg3));
    }

    public final Appl4Term withArg2(ITerm value) {
        if (this.arg2 == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "arg2");
        return Appl4Term.validate(new Appl4Term(this.attachments, this.op, this.arg0, this.arg1, newValue, this.arg3));
    }

    public final Appl4Term withArg3(ITerm value) {
        if (this.arg3 == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "arg3");
        return Appl4Term.validate(new Appl4Term(this.attachments, this.op, this.arg0, this.arg1, this.arg2, newValue));
    }

    public static Appl4Term of(String op, ITerm arg0, ITerm arg1, ITerm arg2, ITerm arg3) {
        return Appl4Term.validate(new Appl4Term(op, arg0, arg1, arg2, arg3));
    }

    private static Appl4Term validate(Appl4Term instance) {
        instance = (Appl4Term)instance.check();
        return instance;
    }

    public static Appl4Term copyOf(AAppl4Term instance) {
        if (instance instanceof Appl4Term) {
            return (Appl4Term)instance;
        }
        return Appl4Term.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return Appl4Term.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ Appl4Term(Builder builder, Appl4Term appl4Term) {
        this(builder);
    }

    public static final class Builder {
        private static final long INIT_BIT_OP = 1L;
        private static final long INIT_BIT_ARG0 = 2L;
        private static final long INIT_BIT_ARG1 = 4L;
        private static final long INIT_BIT_ARG2 = 8L;
        private static final long INIT_BIT_ARG3 = 16L;
        private long initBits = 31L;
        private IAttachments attachments;
        private String op;
        private ITerm arg0;
        private ITerm arg1;
        private ITerm arg2;
        private ITerm arg3;

        private Builder() {
        }

        public final Builder from(AAppl4Term instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ITerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(AbstractApplTerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(AbstractTerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(IApplTerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            ITerm instance;
            long bits = 0L;
            if (object instanceof AAppl4Term) {
                instance = (AAppl4Term)object;
                this.arg3(((AAppl4Term)instance).getArg3());
                if ((bits & 1L) == 0L) {
                    this.op(((AAppl4Term)instance).getOp());
                    bits |= 1L;
                }
                this.arg2(((AAppl4Term)instance).getArg2());
                this.arg1(((AAppl4Term)instance).getArg1());
                this.arg0(((AAppl4Term)instance).getArg0());
            }
            if (object instanceof ITerm) {
                instance = (ITerm)object;
                if ((bits & 2L) == 0L) {
                    this.attachments(instance.getAttachments());
                    bits |= 2L;
                }
            }
            if (object instanceof AbstractApplTerm) {
                instance = (AbstractApplTerm)object;
                if ((bits & 1L) == 0L) {
                    this.op(((AbstractApplTerm)instance).getOp());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.attachments(((AbstractTerm)instance).getAttachments());
                    bits |= 2L;
                }
            }
            if (object instanceof AbstractTerm) {
                instance = (AbstractTerm)object;
                if ((bits & 2L) == 0L) {
                    this.attachments(((AbstractTerm)instance).getAttachments());
                    bits |= 2L;
                }
            }
            if (object instanceof IApplTerm) {
                instance = (IApplTerm)object;
                if ((bits & 1L) == 0L) {
                    this.op(instance.getOp());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.attachments(instance.getAttachments());
                    bits |= 2L;
                }
            }
        }

        public final Builder attachments(IAttachments attachments) {
            this.attachments = Objects.requireNonNull(attachments, "attachments");
            return this;
        }

        public final Builder op(String op) {
            this.op = Objects.requireNonNull(op, "op");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder arg0(ITerm arg0) {
            this.arg0 = Objects.requireNonNull(arg0, "arg0");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder arg1(ITerm arg1) {
            this.arg1 = Objects.requireNonNull(arg1, "arg1");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder arg2(ITerm arg2) {
            this.arg2 = Objects.requireNonNull(arg2, "arg2");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder arg3(ITerm arg3) {
            this.arg3 = Objects.requireNonNull(arg3, "arg3");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public Appl4Term build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return Appl4Term.validate(new Appl4Term(this, null));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("op");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("arg0");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("arg1");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("arg2");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("arg3");
            }
            return "Cannot build Appl4Term, some of required attributes are not set " + attributes;
        }
    }
}

