/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.symbolic;

import io.usethesource.capsule.Set;
import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.symbolic.ASymbolicConstraints;
import mb.nabl2.terms.ITerm;

public final class SymbolicConstraints
extends ASymbolicConstraints
implements Serializable {
    private final Set.Immutable<ITerm> facts;
    private final Set.Immutable<ITerm> goals;
    private static final long serialVersionUID = 42L;

    private SymbolicConstraints(Set.Immutable<ITerm> facts, Set.Immutable<ITerm> goals) {
        this.facts = Objects.requireNonNull(facts, "facts");
        this.goals = Objects.requireNonNull(goals, "goals");
    }

    private SymbolicConstraints(SymbolicConstraints original, Set.Immutable<ITerm> facts, Set.Immutable<ITerm> goals) {
        this.facts = facts;
        this.goals = goals;
    }

    @Override
    public Set.Immutable<ITerm> getFacts() {
        return this.facts;
    }

    @Override
    public Set.Immutable<ITerm> getGoals() {
        return this.goals;
    }

    public final SymbolicConstraints withFacts(Set.Immutable<ITerm> value) {
        if (this.facts == value) {
            return this;
        }
        Set.Immutable<ITerm> newValue = Objects.requireNonNull(value, "facts");
        return new SymbolicConstraints(this, newValue, this.goals);
    }

    public final SymbolicConstraints withGoals(Set.Immutable<ITerm> value) {
        if (this.goals == value) {
            return this;
        }
        Set.Immutable<ITerm> newValue = Objects.requireNonNull(value, "goals");
        return new SymbolicConstraints(this, this.facts, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SymbolicConstraints && this.equalTo(0, (SymbolicConstraints)another);
    }

    private boolean equalTo(int synthetic, SymbolicConstraints another) {
        return this.facts.equals(another.facts) && this.goals.equals(another.goals);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.facts.hashCode();
        h += (h << 5) + this.goals.hashCode();
        return h;
    }

    public String toString() {
        return "SymbolicConstraints{facts=" + this.facts + ", goals=" + this.goals + "}";
    }

    public static SymbolicConstraints of(Set.Immutable<ITerm> facts, Set.Immutable<ITerm> goals) {
        return new SymbolicConstraints(facts, goals);
    }

    public static SymbolicConstraints copyOf(ASymbolicConstraints instance) {
        if (instance instanceof SymbolicConstraints) {
            return (SymbolicConstraints)instance;
        }
        return SymbolicConstraints.of(instance.getFacts(), instance.getGoals());
    }
}

