/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.solver.solvers;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import mb.nabl2.config.NaBL2DebugConfig;
import mb.nabl2.constraints.IConstraint;
import mb.nabl2.relations.variants.IVariantRelation;
import mb.nabl2.relations.variants.VariantRelations;
import mb.nabl2.solver.ISolution;
import mb.nabl2.solver.ISolver;
import mb.nabl2.solver.Solution;
import mb.nabl2.solver.SolveResult;
import mb.nabl2.solver.SolverConfig;
import mb.nabl2.solver.SolverCore;
import mb.nabl2.solver.components.BaseComponent;
import mb.nabl2.solver.components.EqualityComponent;
import mb.nabl2.solver.components.NameResolutionComponent;
import mb.nabl2.solver.components.NameResolutionResult;
import mb.nabl2.solver.components.NameSetsComponent;
import mb.nabl2.solver.components.RelationComponent;
import mb.nabl2.solver.components.SetComponent;
import mb.nabl2.solver.components.SymbolicComponent;
import mb.nabl2.solver.exceptions.SolverException;
import mb.nabl2.solver.messages.IMessages;
import mb.nabl2.solver.solvers.BaseSolver;
import mb.nabl2.solver.solvers.CallExternal;
import mb.nabl2.solver.solvers.FixedPointSolver;
import mb.nabl2.solver.solvers.GraphSolution;
import mb.nabl2.symbolic.ISymbolicConstraints;
import mb.nabl2.symbolic.SymbolicConstraints;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.nabl2.util.collections.Properties;
import mb.scopegraph.pepm16.ScopeGraphReducer;
import mb.scopegraph.pepm16.esop15.CriticalEdge;
import mb.scopegraph.pepm16.esop15.IEsopNameResolution;
import mb.scopegraph.pepm16.esop15.IEsopScopeGraph;
import mb.scopegraph.pepm16.terms.Label;
import mb.scopegraph.pepm16.terms.Occurrence;
import mb.scopegraph.pepm16.terms.Scope;
import org.metaborg.util.Ref;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.functions.Predicate1;
import org.metaborg.util.functions.Predicate2;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;

public class BaseMultiFileSolver
extends BaseSolver {
    public BaseMultiFileSolver(NaBL2DebugConfig nabl2Debug, CallExternal callExternal) {
        super(nabl2Debug, callExternal);
    }

    public ISolution solveIntra(GraphSolution initial, Iterable<ITermVar> intfVars, @Nullable Collection<Scope> intfScopes, Function1<String, String> fresh, ICancel cancel, IProgress progress) throws SolverException, InterruptedException {
        SolverConfig config = initial.config();
        Ref<IUnifier.Immutable> unifier = new Ref<IUnifier.Immutable>(initial.unifier());
        Predicate2<Scope, Label> isEdgeClosed = (s, l) -> intfScopes != null && !intfScopes.contains(s);
        IEsopScopeGraph.Transient<Scope, Label, Occurrence, ITerm> scopeGraph = initial.scopeGraph().melt();
        IEsopNameResolution<Scope, Label, Occurrence> nameResolution = IEsopNameResolution.of(config.getResolutionParams(), scopeGraph, isEdgeClosed);
        ScopeGraphReducer scopeGraphReducer = new ScopeGraphReducer(scopeGraph, unifier);
        SolverCore core = new SolverCore(config, unifier, fresh, this.callExternal, cancel, progress);
        BaseComponent baseSolver = new BaseComponent(core);
        EqualityComponent equalitySolver = new EqualityComponent(core, unifier);
        NameResolutionComponent nameResolutionSolver = new NameResolutionComponent(core, scopeGraph, nameResolution, Properties.Transient.of());
        NameSetsComponent nameSetSolver = new NameSetsComponent(core, nameResolution);
        RelationComponent relationSolver = new RelationComponent(core, Predicate1.never(), config.getFunctions(), (Map<String, IVariantRelation.Transient<ITerm>>)VariantRelations.transientOf(config.getRelations()));
        SetComponent setSolver = new SetComponent(core, nameSetSolver.nameSets());
        SymbolicComponent symSolver = new SymbolicComponent(core, SymbolicConstraints.of());
        ISolver component = c -> c.matchOrThrow(IConstraint.CheckedCases.builder().onBase(baseSolver::solve).onEquality(equalitySolver::solve).onNameResolution(nameResolutionSolver::solve).onRelation(relationSolver::solve).onSet(setSolver::solve).onSym(symSolver::solve).otherwise(ISolver.defer()));
        FixedPointSolver solver = new FixedPointSolver(cancel, progress, component);
        solver.step().subscribe(r -> {
            Set.Immutable<ITermVar> vars = r.result.unifierDiff().domainSet();
            if (!vars.isEmpty()) {
                try {
                    List<CriticalEdge> criticalEdges = scopeGraphReducer.update((Iterable<? extends ITerm>)vars);
                    nameResolution.update(criticalEdges, cancel, progress);
                    r.resolveCriticalEdges(criticalEdges);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        try {
            scopeGraphReducer.updateAll();
            SolveResult solveResult = solver.solve((Collection<? extends IConstraint>)initial.constraints(), unifier);
            NameResolutionResult nameResolutionResult = nameResolutionSolver.finish();
            IUnifier.Immutable unifierResult = equalitySolver.finish();
            Map.Immutable<String, IVariantRelation.Immutable<ITerm>> relationResult = relationSolver.finish();
            ISymbolicConstraints symbolicConstraints = symSolver.finish();
            setSolver.finish();
            IMessages.Transient messages = initial.messages().melt();
            messages.addAll(solveResult.messages());
            Solution solution = Solution.of(config, initial.astProperties(), nameResolutionResult.scopeGraph(), nameResolutionResult.declProperties(), relationResult, unifierResult, symbolicConstraints, messages.freeze(), solveResult.constraints()).withNameResolutionCache(nameResolutionResult.resolutionCache());
            return solution;
        }
        catch (RuntimeException ex) {
            throw new SolverException("Internal solver error.", ex);
        }
    }
}

