/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.solver.components;

import java.util.Optional;
import mb.nabl2.constraints.messages.IMessageInfo;
import mb.nabl2.constraints.scopegraph.CGDecl;
import mb.nabl2.constraints.scopegraph.CGDirectEdge;
import mb.nabl2.constraints.scopegraph.CGExportEdge;
import mb.nabl2.constraints.scopegraph.CGImportEdge;
import mb.nabl2.constraints.scopegraph.CGRef;
import mb.nabl2.constraints.scopegraph.IScopeGraphConstraint;
import mb.nabl2.solver.ASolver;
import mb.nabl2.solver.SeedResult;
import mb.nabl2.solver.SolveResult;
import mb.nabl2.solver.SolverCore;
import mb.nabl2.solver.TypeException;
import mb.nabl2.solver.exceptions.DelayException;
import mb.nabl2.solver.exceptions.VariableDelayException;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.scopegraph.pepm16.esop15.IEsopScopeGraph;
import mb.scopegraph.pepm16.terms.Label;
import mb.scopegraph.pepm16.terms.Occurrence;
import mb.scopegraph.pepm16.terms.Scope;
import org.metaborg.util.iterators.Iterables2;

public class ScopeGraphComponent
extends ASolver {
    private final IEsopScopeGraph.Transient<Scope, Label, Occurrence, ITerm> scopeGraph;

    public ScopeGraphComponent(SolverCore core, IEsopScopeGraph.Transient<Scope, Label, Occurrence, ITerm> initial) {
        super(core);
        this.scopeGraph = initial;
    }

    public SeedResult seed(IEsopScopeGraph.Immutable<Scope, Label, Occurrence, ITerm> solution, IMessageInfo message) throws InterruptedException {
        this.scopeGraph.addAll(solution, this.unifier()::getVars);
        return SeedResult.empty();
    }

    public SolveResult solve(IScopeGraphConstraint constraint) throws DelayException {
        return constraint.matchOrThrow(IScopeGraphConstraint.CheckedCases.of(this::solve, this::solve, this::solve, this::solve, this::solve));
    }

    public IEsopScopeGraph.Immutable<Scope, Label, Occurrence, ITerm> finish() {
        return this.scopeGraph.freeze();
    }

    private SolveResult solve(CGDecl c) throws DelayException {
        ITerm scopeTerm = c.getScope();
        ITerm declTerm = c.getDeclaration();
        if (!this.unifier().isGround(scopeTerm) || !this.unifier().isGround(declTerm)) {
            throw new VariableDelayException(Iterables2.fromConcat(new Iterable[]{this.unifier().getVars(scopeTerm), this.unifier().getVars(declTerm)}));
        }
        Scope scope = Scope.matcher().match(scopeTerm, this.unifier()).orElseThrow(() -> new TypeException("Expected a scope as first agument to " + c));
        Occurrence decl = Occurrence.matcher().match(declTerm, this.unifier()).orElseThrow(() -> new TypeException("Expected an occurrence as second argument to " + c));
        this.scopeGraph.addDecl(scope, decl);
        return SolveResult.empty();
    }

    private SolveResult solve(CGRef c) throws DelayException {
        ITerm scopeTerm = c.getScope();
        ITerm refTerm = c.getReference();
        if (!this.unifier().isGround(scopeTerm) || !this.unifier().isGround(refTerm)) {
            throw new VariableDelayException(Iterables2.fromConcat(new Iterable[]{this.unifier().getVars(scopeTerm), this.unifier().getVars(refTerm)}));
        }
        Occurrence ref = Occurrence.matcher().match(refTerm, this.unifier()).orElseThrow(() -> new TypeException("Expected an occurrence as first argument to " + c));
        Scope scope = Scope.matcher().match(scopeTerm, this.unifier()).orElseThrow(() -> new TypeException("Expected a scope as second argument to " + c));
        this.scopeGraph.addRef(ref, scope);
        return SolveResult.empty();
    }

    private SolveResult solve(CGDirectEdge c) throws DelayException {
        ITerm sourceScopeRep = c.getSourceScope();
        if (!this.unifier().isGround(sourceScopeRep)) {
            throw new VariableDelayException((Iterable<ITermVar>)this.unifier().getVars(sourceScopeRep));
        }
        Scope sourceScope = Scope.matcher().match(sourceScopeRep, this.unifier()).orElseThrow(() -> new TypeException("Expected a scope but got " + sourceScopeRep));
        return this.findScope(c.getTargetScope()).map(targetScope -> {
            this.scopeGraph.addDirectEdge(sourceScope, c.getLabel(), (Scope)targetScope);
            return SolveResult.empty();
        }).orElseGet(() -> {
            this.scopeGraph.addIncompleteDirectEdge(sourceScope, c.getLabel(), c.getTargetScope(), this.unifier()::getVars);
            return SolveResult.empty();
        });
    }

    private SolveResult solve(CGImportEdge c) throws DelayException {
        ITerm scopeRep = c.getScope();
        if (!this.unifier().isGround(scopeRep)) {
            throw new VariableDelayException((Iterable<ITermVar>)this.unifier().getVars(scopeRep));
        }
        Scope scope = Scope.matcher().match(scopeRep, this.unifier()).orElseThrow(() -> new TypeException("Expected a scope but got " + scopeRep));
        return this.findOccurrence(c.getReference()).map(ref -> {
            this.scopeGraph.addImportEdge(scope, c.getLabel(), (Occurrence)ref);
            return SolveResult.empty();
        }).orElseGet(() -> {
            this.scopeGraph.addIncompleteImportEdge(scope, c.getLabel(), c.getReference(), this.unifier()::getVars);
            return SolveResult.empty();
        });
    }

    private SolveResult solve(CGExportEdge c) throws DelayException {
        ITerm scopeTerm = c.getScope();
        ITerm declTerm = c.getDeclaration();
        if (!this.unifier().isGround(scopeTerm) || !this.unifier().isGround(declTerm)) {
            throw new VariableDelayException(Iterables2.fromConcat(new Iterable[]{this.unifier().getVars(scopeTerm), this.unifier().getVars(declTerm)}));
        }
        Scope scope = Scope.matcher().match(scopeTerm, this.unifier()).orElseThrow(() -> new TypeException("Expected a scope as third argument to " + c));
        Occurrence decl = Occurrence.matcher().match(declTerm, this.unifier()).orElseThrow(() -> new TypeException("Expected an occurrence as first argument to " + c));
        this.scopeGraph.addExportEdge(decl, c.getLabel(), scope);
        return SolveResult.empty();
    }

    private Optional<Scope> findScope(ITerm scopeTerm) {
        return Optional.of(scopeTerm).filter(this.unifier()::isGround).map(st -> Scope.matcher().match((ITerm)st, this.unifier()).orElseThrow(() -> new TypeException("Expected a scope, got " + st)));
    }

    private Optional<Occurrence> findOccurrence(ITerm occurrenceTerm) {
        return Optional.of(occurrenceTerm).filter(this.unifier()::isGround).map(ot -> Occurrence.matcher().match((ITerm)ot, this.unifier()).orElseThrow(() -> new TypeException("Expected an occurrence, got " + ot)));
    }
}

