/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.solver.components;

import io.usethesource.capsule.Set;
import java.util.Optional;
import mb.nabl2.constraints.IConstraint;
import mb.nabl2.constraints.equality.CEqual;
import mb.nabl2.constraints.equality.CInequal;
import mb.nabl2.constraints.equality.IEqualityConstraint;
import mb.nabl2.constraints.messages.IMessageInfo;
import mb.nabl2.constraints.messages.MessageContent;
import mb.nabl2.solver.ASolver;
import mb.nabl2.solver.SeedResult;
import mb.nabl2.solver.SolveResult;
import mb.nabl2.solver.SolverCore;
import mb.nabl2.solver.exceptions.VariableDelayException;
import mb.nabl2.solver.messages.Messages;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.unification.OccursException;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.nabl2.unification.UnificationMessages;
import org.metaborg.util.Ref;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.iterators.Iterables2;

public class EqualityComponent
extends ASolver {
    private final Ref<IUnifier.Immutable> unifier;

    public EqualityComponent(SolverCore core, Ref<IUnifier.Immutable> unifier) {
        super(core);
        this.unifier = unifier;
    }

    public SeedResult seed(IUnifier.Immutable solution, IMessageInfo message) throws InterruptedException {
        Set.Transient constraints = CapsuleUtil.transientSet();
        Messages.Transient messages = Messages.Transient.of();
        try {
            IUnifier.Transient unifier = this.unifier.get().melt();
            if (!unifier.unify(solution).isPresent()) {
                messages.add(message.withContent(MessageContent.of("Unification failed.")));
            } else {
                this.unifier.set(unifier.freeze());
            }
        }
        catch (OccursException e) {
            MessageContent content = MessageContent.of("Recursive unifier");
            messages.add(message.withContent(content));
        }
        return SeedResult.builder().constraints((Set.Immutable<IConstraint>)constraints.freeze()).messages(messages.freeze()).build();
    }

    public SolveResult solve(IEqualityConstraint constraint) throws VariableDelayException {
        return constraint.matchOrThrow(IEqualityConstraint.CheckedCases.of(this::solve, this::solve));
    }

    public IUnifier.Immutable finish() {
        return this.unifier.get();
    }

    private SolveResult solve(CEqual constraint) {
        ITerm left = constraint.getLeft();
        ITerm right = constraint.getRight();
        IUnifier.Transient unifier = this.unifier.get().melt();
        IUnifier.Immutable unifyResult = null;
        try {
            unifyResult = unifier.unify(left, right).orElse(null);
        }
        catch (OccursException occursException) {
            // empty catch block
        }
        if (unifyResult != null) {
            SolveResult solveResult = SolveResult.builder().unifierDiff(unifyResult).build();
            this.unifier.set(unifier.freeze());
            return solveResult;
        }
        MessageContent content = UnificationMessages.getError(left, right);
        IMessageInfo message = constraint.getMessageInfo().withDefaultContent(content);
        SolveResult solveResult = SolveResult.messages(message);
        return solveResult;
    }

    private SolveResult solve(CInequal constraint) throws VariableDelayException {
        ITerm left = constraint.getLeft();
        ITerm right = constraint.getRight();
        Optional<? extends IUnifier.Immutable> result = this.unifier().diff(left, right);
        if (!result.isPresent()) {
            return SolveResult.empty();
        }
        if (result.get().isEmpty()) {
            MessageContent content = MessageContent.builder().append(constraint.getLeft().toString()).append(" and ").append(constraint.getRight().toString()).append(" must be inequal, but are not.").build();
            IMessageInfo message = constraint.getMessageInfo().withDefaultContent(content);
            return SolveResult.messages(message);
        }
        Iterable<ITermVar> termVars = Iterables2.fromConcat(new Iterable[]{this.unifier().getVars(left), this.unifier().getVars(right)});
        throw new VariableDelayException(termVars);
    }
}

