/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.solver;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import mb.nabl2.relations.variants.VariantRelationDescription;
import mb.nabl2.solver.ASolverConfig;
import mb.nabl2.terms.ITerm;
import mb.scopegraph.pepm16.terms.ResolutionParameters;
import org.metaborg.util.functions.PartialFunction1;

public final class SolverConfig
extends ASolverConfig
implements Serializable {
    private final ResolutionParameters resolutionParams;
    private final Map<String, VariantRelationDescription<ITerm>> relations;
    private final Map<String, PartialFunction1<ITerm, ITerm>> functions;
    private static final long serialVersionUID = 42L;

    private SolverConfig(ResolutionParameters resolutionParams, Map<String, ? extends VariantRelationDescription<ITerm>> relations, Map<String, ? extends PartialFunction1<ITerm, ITerm>> functions) {
        this.resolutionParams = Objects.requireNonNull(resolutionParams, "resolutionParams");
        this.relations = SolverConfig.createUnmodifiableMap(true, false, relations);
        this.functions = SolverConfig.createUnmodifiableMap(true, false, functions);
    }

    private SolverConfig(SolverConfig original, ResolutionParameters resolutionParams, Map<String, VariantRelationDescription<ITerm>> relations, Map<String, PartialFunction1<ITerm, ITerm>> functions) {
        this.resolutionParams = resolutionParams;
        this.relations = relations;
        this.functions = functions;
    }

    @Override
    public ResolutionParameters getResolutionParams() {
        return this.resolutionParams;
    }

    @Override
    public Map<String, VariantRelationDescription<ITerm>> getRelations() {
        return this.relations;
    }

    @Override
    public Map<String, PartialFunction1<ITerm, ITerm>> getFunctions() {
        return this.functions;
    }

    public final SolverConfig withResolutionParams(ResolutionParameters value) {
        if (this.resolutionParams == value) {
            return this;
        }
        ResolutionParameters newValue = Objects.requireNonNull(value, "resolutionParams");
        return new SolverConfig(this, newValue, this.relations, this.functions);
    }

    public final SolverConfig withRelations(Map<String, ? extends VariantRelationDescription<ITerm>> entries) {
        if (this.relations == entries) {
            return this;
        }
        Map<String, VariantRelationDescription<ITerm>> newValue = SolverConfig.createUnmodifiableMap(true, false, entries);
        return new SolverConfig(this, this.resolutionParams, newValue, this.functions);
    }

    public final SolverConfig withFunctions(Map<String, ? extends PartialFunction1<ITerm, ITerm>> entries) {
        if (this.functions == entries) {
            return this;
        }
        Map<String, PartialFunction1<ITerm, ITerm>> newValue = SolverConfig.createUnmodifiableMap(true, false, entries);
        return new SolverConfig(this, this.resolutionParams, this.relations, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SolverConfig && this.equalTo(0, (SolverConfig)another);
    }

    private boolean equalTo(int synthetic, SolverConfig another) {
        return this.resolutionParams.equals(another.resolutionParams) && this.relations.equals(another.relations) && this.functions.equals(another.functions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.resolutionParams.hashCode();
        h += (h << 5) + this.relations.hashCode();
        h += (h << 5) + this.functions.hashCode();
        return h;
    }

    public String toString() {
        return "SolverConfig{resolutionParams=" + this.resolutionParams + ", relations=" + this.relations + ", functions=" + this.functions + "}";
    }

    public static SolverConfig of(ResolutionParameters resolutionParams, Map<String, ? extends VariantRelationDescription<ITerm>> relations, Map<String, ? extends PartialFunction1<ITerm, ITerm>> functions) {
        return new SolverConfig(resolutionParams, relations, functions);
    }

    public static SolverConfig copyOf(ASolverConfig instance) {
        if (instance instanceof SolverConfig) {
            return (SolverConfig)instance;
        }
        return SolverConfig.of(instance.getResolutionParams(), instance.getRelations(), instance.getFunctions());
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }
}

