/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.relations.variants;

import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.relations.terms.RelationName;
import mb.nabl2.relations.variants.Variances;

public final class Contravariant
extends Variances.AContravariant
implements Serializable {
    private final RelationName relation;
    private static final long serialVersionUID = 42L;

    private Contravariant(RelationName relation) {
        this.relation = Objects.requireNonNull(relation, "relation");
    }

    private Contravariant(Contravariant original, RelationName relation) {
        this.relation = relation;
    }

    @Override
    public RelationName getRelation() {
        return this.relation;
    }

    public final Contravariant withRelation(RelationName value) {
        if (this.relation == value) {
            return this;
        }
        RelationName newValue = Objects.requireNonNull(value, "relation");
        return new Contravariant(this, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Contravariant && this.equalTo(0, (Contravariant)another);
    }

    private boolean equalTo(int synthetic, Contravariant another) {
        return this.relation.equals(another.relation);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.relation.hashCode();
        return h;
    }

    public String toString() {
        return "Contravariant{relation=" + this.relation + "}";
    }

    public static Contravariant of(RelationName relation) {
        return new Contravariant(relation);
    }

    public static Contravariant copyOf(Variances.AContravariant instance) {
        if (instance instanceof Contravariant) {
            return (Contravariant)instance;
        }
        return Contravariant.of(instance.getRelation());
    }
}

