/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.relations.terms;

import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.relations.terms.RelationName;
import mb.nabl2.terms.IAttachments;
import mb.nabl2.terms.ITerm;
import org.metaborg.util.collection.ImList;

final class ExtRelation
extends RelationName.AExtRelation
implements Serializable {
    private final IAttachments attachments;
    private final String name;
    private volatile transient long lazyInitBitmap;
    private static final long OP_LAZY_INIT_BIT = 1L;
    private transient String op;
    private static final long ARGS_LAZY_INIT_BIT = 2L;
    private transient ImList.Immutable<ITerm> args;
    private static final long serialVersionUID = 42L;

    private ExtRelation(String name) {
        this.name = Objects.requireNonNull(name, "name");
        this.attachments = Objects.requireNonNull(super.getAttachments(), "attachments");
    }

    private ExtRelation(IAttachments attachments, String name) {
        this.attachments = attachments;
        this.name = name;
    }

    @Override
    public IAttachments getAttachments() {
        return this.attachments;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public final ExtRelation withAttachments(IAttachments value) {
        if (this.attachments == value) {
            return this;
        }
        IAttachments newValue = Objects.requireNonNull(value, "attachments");
        return new ExtRelation(newValue, this.name);
    }

    public final ExtRelation withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ExtRelation(this.attachments, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getOp() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ExtRelation extRelation = this;
            synchronized (extRelation) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.op = Objects.requireNonNull(super.getOp(), "op");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImList.Immutable<ITerm> getArgs() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ExtRelation extRelation = this;
            synchronized (extRelation) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.args = Objects.requireNonNull(super.getArgs(), "args");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.args;
    }

    public static ExtRelation of(String name) {
        return new ExtRelation(name);
    }

    public static ExtRelation copyOf(RelationName.AExtRelation instance) {
        if (instance instanceof ExtRelation) {
            return (ExtRelation)instance;
        }
        return ExtRelation.of(instance.getName()).withAttachments(instance.getAttachments());
    }
}

