/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.constraints.equality;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.constraints.equality.ACInequal;
import mb.nabl2.constraints.messages.IMessageInfo;
import mb.nabl2.terms.ITerm;

public final class CInequal
extends ACInequal
implements Serializable {
    private final ITerm left;
    private final ITerm right;
    private final IMessageInfo messageInfo;
    private final int hashCode;
    private static final long serialVersionUID = 42L;

    private CInequal(ITerm left, ITerm right, IMessageInfo messageInfo) {
        this.left = Objects.requireNonNull(left, "left");
        this.right = Objects.requireNonNull(right, "right");
        this.messageInfo = Objects.requireNonNull(messageInfo, "messageInfo");
        this.hashCode = this.computeHashCode();
    }

    private CInequal(CInequal original, ITerm left, ITerm right, IMessageInfo messageInfo) {
        this.left = left;
        this.right = right;
        this.messageInfo = messageInfo;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public ITerm getLeft() {
        return this.left;
    }

    @Override
    public ITerm getRight() {
        return this.right;
    }

    @Override
    public IMessageInfo getMessageInfo() {
        return this.messageInfo;
    }

    public final CInequal withLeft(ITerm value) {
        if (this.left == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "left");
        return new CInequal(this, newValue, this.right, this.messageInfo);
    }

    public final CInequal withRight(ITerm value) {
        if (this.right == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "right");
        return new CInequal(this, this.left, newValue, this.messageInfo);
    }

    public final CInequal withMessageInfo(IMessageInfo value) {
        if (this.messageInfo == value) {
            return this;
        }
        IMessageInfo newValue = Objects.requireNonNull(value, "messageInfo");
        return new CInequal(this, this.left, this.right, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CInequal && this.equalTo(0, (CInequal)another);
    }

    private boolean equalTo(int synthetic, CInequal another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.left.equals(another.left) && this.right.equals(another.right) && this.messageInfo.equals(another.messageInfo);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.left.hashCode();
        h += (h << 5) + this.right.hashCode();
        h += (h << 5) + this.messageInfo.hashCode();
        return h;
    }

    public static CInequal of(ITerm left, ITerm right, IMessageInfo messageInfo) {
        return new CInequal(left, right, messageInfo);
    }

    public static CInequal copyOf(ACInequal instance) {
        if (instance instanceof CInequal) {
            return (CInequal)instance;
        }
        return CInequal.of(instance.getLeft(), instance.getRight(), instance.getMessageInfo());
    }

    private Object readResolve() throws ObjectStreamException {
        return new CInequal(this, this.left, this.right, this.messageInfo);
    }
}

