/*
 * Decompiled with CFR 0.152.
 */
package mb.jsglr.shared;

import mb.jsglr.shared.LabelInfo;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoNamed;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.interpreter.terms.TermType;
import org.spoofax.terms.StrategoListIterator;
import org.spoofax.terms.Term;

public class ProductionAttributeReader {
    private static final String WATER = "WATER";
    private static final String INSERT = "INSERTION";
    private static final String INSERT_END = "INSERTEND";
    private static final String INSERT_OPEN_QUOTE = "INSERTOPENQUOTE";
    private final int PARAMETRIZED_SORT_NAME = 0;
    private final int PARAMETRIZED_SORT_ARGS = 1;
    private final int ALT_SORT_LEFT = 0;
    private final int ALT_SORT_RIGHT = 1;
    protected final IStrategoConstructor sortFun;
    protected final IStrategoConstructor parameterizedSortFun;
    private final IStrategoConstructor noAttrsFun;
    private final IStrategoConstructor varSymFun;
    private final IStrategoConstructor altFun;
    private final IStrategoConstructor charClassFun;
    private final IStrategoConstructor litFun;
    private final IStrategoConstructor cilitFun;
    private final IStrategoConstructor lexFun;
    private final IStrategoConstructor optFun;
    private final IStrategoConstructor layoutFun;
    private final IStrategoConstructor cfFun;
    private final IStrategoConstructor varsymFun;
    private final IStrategoConstructor seqFun;
    private final IStrategoConstructor iterFun;
    private final IStrategoConstructor iterStarFun;
    private final IStrategoConstructor iterPlusFun;
    private final IStrategoConstructor iterSepFun;
    private final IStrategoConstructor iterStarSepFun;
    private final IStrategoConstructor iterPlusSepFun;

    public ProductionAttributeReader(ITermFactory factory) {
        this.sortFun = factory.makeConstructor("sort", 1);
        this.parameterizedSortFun = factory.makeConstructor("parameterized-sort", 2);
        this.noAttrsFun = factory.makeConstructor("no-attrs", 0);
        this.varSymFun = factory.makeConstructor("varsym", 1);
        this.altFun = factory.makeConstructor("alt", 2);
        this.charClassFun = factory.makeConstructor("char-class", 1);
        this.litFun = factory.makeConstructor("lit", 1);
        this.cilitFun = factory.makeConstructor("cilit", 1);
        this.lexFun = factory.makeConstructor("lex", 1);
        this.optFun = factory.makeConstructor("opt", 1);
        this.layoutFun = factory.makeConstructor("layout", 0);
        this.cfFun = factory.makeConstructor("cf", 1);
        this.varsymFun = factory.makeConstructor("varsym", 1);
        this.seqFun = factory.makeConstructor("seq", 2);
        this.iterFun = factory.makeConstructor("iter", 1);
        this.iterStarFun = factory.makeConstructor("iter-star", 1);
        this.iterPlusFun = factory.makeConstructor("iter-plus", 1);
        this.iterSepFun = factory.makeConstructor("iter-sep", 2);
        this.iterStarSepFun = factory.makeConstructor("iter-star-sep", 2);
        this.iterPlusSepFun = factory.makeConstructor("iter-plus-sep", 2);
    }

    public String getConsAttribute(IStrategoAppl attrs) {
        IStrategoTerm consAttr = this.getAttribute(attrs, "cons");
        return consAttr == null ? null : ((IStrategoNamed)consAttr).getName();
    }

    public boolean isWaterConstructor(String constructor) {
        return WATER.equals(constructor);
    }

    public boolean isIgnoredUnspecifiedRecoverySort(String sort) {
        return sort != null && sort.startsWith(WATER);
    }

    public boolean isInsertEndConstructor(String constructor) {
        return INSERT_END.equals(constructor);
    }

    public boolean isInsertOpenQuoteSort(String sort) {
        return sort != null && sort.startsWith(INSERT_OPEN_QUOTE);
    }

    public boolean isInsertConstructor(String constructor) {
        return INSERT.equals(constructor);
    }

    public boolean isRecoverProduction(IStrategoAppl attrs, String constructor) {
        return this.getAttribute(attrs, "recover") != null || this.isWaterConstructor(constructor);
    }

    public boolean isCompletionProduction(IStrategoAppl attrs, int subtermCount) {
        return this.getAttribute(attrs, "completion") != null && subtermCount > 0;
    }

    public boolean isBracketProduction(IStrategoAppl attrs) {
        return this.getAttribute(attrs, "bracket") != null;
    }

    public boolean isRejectProduction(IStrategoAppl attrs) {
        return this.getAttribute(attrs, "reject") != null;
    }

    public String getDeprecationMessage(IStrategoAppl attrs) {
        IStrategoTerm deprecated = this.getAttribute(attrs, "deprecated");
        if (deprecated == null) {
            return null;
        }
        StringBuilder msg = new StringBuilder("Deprecated construct");
        if (deprecated.getType() == TermType.STRING) {
            msg.append(": ");
            msg.append(Term.asJavaString(deprecated));
            return msg.toString();
        }
        return msg.toString();
    }

    public String getSyntaxErrorExpectedInsertion(LabelInfo label) {
        String inserted;
        IStrategoList lhs = label.getLHS();
        IStrategoAppl rhs = label.getRHS();
        if (rhs.getName().equals("lit")) {
            inserted = "'" + ((IStrategoNamed)Term.termAt(rhs, 0)).getName() + "'";
        } else if (lhs.getSubtermCount() == 1 && Term.tryGetConstructor(Term.termAt(lhs, 0)) == this.litFun) {
            inserted = "'" + Term.asJavaString(Term.termAt(Term.termAt(lhs, 0), 0)) + "'";
        } else if (rhs.getName().equals("char-class")) {
            inserted = "'" + ProductionAttributeReader.toString((IStrategoList)Term.termAt(rhs, 0)) + "'";
        } else {
            inserted = this.getSort(rhs);
            if (inserted == null) {
                inserted = "token";
            }
        }
        return inserted;
    }

    private static String toString(IStrategoList chars) {
        StringBuilder result = new StringBuilder(chars.getSubtermCount());
        while (chars.head() != null) {
            IStrategoInt v = (IStrategoInt)chars.head();
            result.append((char)v.intValue());
            chars = chars.tail();
        }
        return result.toString();
    }

    public String getMetaVarConstructor(IStrategoAppl rhs, IStrategoAppl attrs) {
        if (this.varSymFun == rhs.getConstructor()) {
            return this.isList(rhs = (IStrategoAppl)Term.termAt(rhs, 0), attrs) ? "meta-listvar" : "meta-var";
        }
        return null;
    }

    public IStrategoTerm getAstAttribute(IStrategoAppl attrs) {
        return this.getAttribute(attrs, "ast");
    }

    public boolean isIndentPaddingLexical(IStrategoAppl attrs) {
        return this.getAttribute(attrs, "indentpadding") != null;
    }

    public IStrategoTerm getAttribute(IStrategoAppl attrs, String attrName) {
        if (attrs.getConstructor() == this.noAttrsFun) {
            return null;
        }
        IStrategoList list = (IStrategoList)Term.termAt(attrs, 0);
        for (IStrategoTerm attr : StrategoListIterator.iterable(list)) {
            if (!Term.isTermNamed(attr)) continue;
            IStrategoNamed namedAttr = (IStrategoNamed)attr;
            if (namedAttr.getName().equals("term") && (namedAttr = (IStrategoNamed)Term.termAt(namedAttr, 0)).getName().equals(attrName)) {
                return namedAttr.getSubtermCount() == 1 ? Term.termAt(namedAttr, 0) : namedAttr;
            }
            if (!namedAttr.getName().equals(attrName)) continue;
            return namedAttr;
        }
        return null;
    }

    public String getSort(IStrategoAppl rhs) {
        IStrategoAppl current = rhs;
        while (current.getSubtermCount() > 0 && Term.isTermAppl(current)) {
            IStrategoAppl currentAppl = current;
            String sort = this.tryGetSort(currentAppl);
            if (sort != null) {
                return sort;
            }
            current = Term.termAt(current, 0);
        }
        return null;
    }

    public String tryGetFirstSort(IStrategoList lhs) {
        IStrategoTerm[] iStrategoTermArray = lhs.getAllSubterms();
        int n = iStrategoTermArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStrategoTerm lhsPart = iStrategoTermArray[n2];
            String sort = this.tryGetSort((IStrategoAppl)lhsPart);
            if (sort != null) {
                return sort;
            }
            ++n2;
        }
        return null;
    }

    public String tryGetSort(IStrategoAppl currentAppl) {
        IStrategoConstructor cons = currentAppl.getConstructor();
        if (cons == this.cfFun) {
            return this.tryGetSort(Term.applAt(currentAppl, 0));
        }
        if (cons == this.lexFun) {
            return this.tryGetSort(Term.applAt(currentAppl, 0));
        }
        if (cons == this.sortFun) {
            return Term.javaString(Term.termAt(currentAppl, 0));
        }
        if (cons == this.parameterizedSortFun) {
            return this.getParameterizedSortName(currentAppl);
        }
        if (cons == this.charClassFun) {
            return null;
        }
        if (cons == this.altFun) {
            return this.getAltSortName(currentAppl);
        }
        return null;
    }

    private String getParameterizedSortName(IStrategoAppl parameterizedSort) {
        StringBuilder result = new StringBuilder();
        result.append(((IStrategoNamed)Term.termAt(parameterizedSort, 0)).getName());
        result.append('_');
        IStrategoList args = (IStrategoList)Term.termAt(parameterizedSort, 1);
        for (IStrategoTerm arg : StrategoListIterator.iterable(args)) {
            result.append(((IStrategoNamed)arg).getName());
        }
        return result.toString();
    }

    private String getAltSortName(IStrategoAppl node) {
        String left = this.getSort(Term.applAt(node, 0));
        String right = this.getSort(Term.applAt(node, 1));
        return String.valueOf(left) + "_" + right + "0";
    }

    public boolean isNonContextFree(IStrategoAppl rhs) {
        return this.lexFun == rhs.getConstructor() || this.isLiteral(rhs) || this.isLayout(rhs) || this.isVariableNode(rhs);
    }

    public boolean isLexical(IStrategoAppl rhs) {
        return this.lexFun == rhs.getConstructor();
    }

    public boolean isLayout(IStrategoAppl rhs) {
        Object details = Term.termAt(rhs, 0);
        if (!Term.isTermAppl(details)) {
            return false;
        }
        if (this.optFun == ((IStrategoAppl)details).getConstructor()) {
            details = Term.termAt(details, 0);
        }
        return this.layoutFun == ((IStrategoAppl)details).getConstructor();
    }

    public boolean isLiteral(IStrategoAppl rhs) {
        IStrategoConstructor fun = rhs.getConstructor();
        return this.litFun == fun || this.cilitFun == fun;
    }

    public boolean isList(IStrategoAppl rhs, IStrategoAppl attrs) {
        IStrategoConstructor fun;
        IStrategoAppl details = rhs;
        if (details.getConstructor() == this.varsymFun) {
            details = (IStrategoAppl)Term.termAt(details, 0);
        }
        if (details.getConstructor() == this.cfFun) {
            details = (IStrategoAppl)Term.termAt(details, 0);
        }
        if (details.getConstructor() == this.optFun) {
            details = (IStrategoAppl)Term.termAt(details, 0);
        }
        if (this.isIterFun(fun = details.getConstructor()) || this.seqFun == fun) {
            return true;
        }
        return this.isFlatten(rhs, attrs);
    }

    public boolean isFlatten(IStrategoAppl rhs, IStrategoAppl attrs) {
        return this.getAttribute(attrs, "flatten") != null;
    }

    public boolean isIterFun(IStrategoConstructor fun) {
        return this.iterFun == fun || this.iterStarFun == fun || this.iterPlusFun == fun || this.iterSepFun == fun || this.iterStarSepFun == fun || this.iterPlusSepFun == fun;
    }

    public boolean isVariableNode(IStrategoAppl rhs) {
        return this.varsymFun == rhs.getConstructor();
    }

    public boolean isLexLayout(IStrategoAppl rhs) {
        if (rhs.getSubtermCount() != 1) {
            return false;
        }
        IStrategoTerm child = rhs.getSubterm(0);
        return Term.isTermAppl(child) && this.layoutFun == ((IStrategoAppl)child).getConstructor() && this.lexFun == rhs.getConstructor();
    }

    public boolean isOptional(IStrategoAppl rhs) {
        if (rhs.getConstructor() == this.optFun) {
            return true;
        }
        Object contents = Term.termAt(rhs, 0);
        return contents.getSubtermCount() == 1 && Term.isTermAppl(contents) && ((IStrategoAppl)contents).getConstructor() == this.optFun;
    }

    public boolean isCaseInsensitive(IStrategoAppl attrs) {
        return this.getAttribute(attrs, "case-insensitive") != null;
    }
}

