/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.runtime.solver;

import java.util.Objects;
import mb.flowspec.runtime.solver.TupleType;
import mb.flowspec.runtime.solver.Type;

public final class ImmutableTupleType
extends TupleType {
    private final Type left;
    private final Type right;
    private final transient int hashCode;

    private ImmutableTupleType(Type left, Type right) {
        this.left = Objects.requireNonNull(left, "left");
        this.right = Objects.requireNonNull(right, "right");
        this.hashCode = this.computeHashCode();
    }

    private ImmutableTupleType(ImmutableTupleType original, Type left, Type right) {
        this.left = left;
        this.right = right;
        this.hashCode = this.computeHashCode();
    }

    @Override
    Type left() {
        return this.left;
    }

    @Override
    Type right() {
        return this.right;
    }

    public final ImmutableTupleType withLeft(Type value) {
        if (this.left == value) {
            return this;
        }
        Type newValue = Objects.requireNonNull(value, "left");
        return new ImmutableTupleType(this, newValue, this.right);
    }

    public final ImmutableTupleType withRight(Type value) {
        if (this.right == value) {
            return this;
        }
        Type newValue = Objects.requireNonNull(value, "right");
        return new ImmutableTupleType(this, this.left, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTupleType && this.equalTo(0, (ImmutableTupleType)another);
    }

    private boolean equalTo(int synthetic, ImmutableTupleType another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.left.equals(another.left) && this.right.equals(another.right);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.left.hashCode();
        h += (h << 5) + this.right.hashCode();
        return h;
    }

    public String toString() {
        return "TupleType{left=" + this.left + ", right=" + this.right + "}";
    }

    public static ImmutableTupleType of(Type left, Type right) {
        return new ImmutableTupleType(left, right);
    }

    public static ImmutableTupleType copyOf(TupleType instance) {
        if (instance instanceof ImmutableTupleType) {
            return (ImmutableTupleType)instance;
        }
        return ImmutableTupleType.of(instance.left(), instance.right());
    }
}

