/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.runtime.lattice;

import io.usethesource.capsule.Set;
import mb.flowspec.runtime.interpreter.SymbolicLargestSetException;
import mb.flowspec.runtime.interpreter.values.ISet;
import mb.flowspec.runtime.interpreter.values.Set;
import mb.flowspec.runtime.lattice.CompleteLattice;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.StrategoConstructor;

public class FullSetLattice<E extends IStrategoTerm>
implements CompleteLattice<ISet<E>> {
    public static final ISet TOP = new ISetImplementation();

    @Override
    public ISet<E> top() {
        return TOP;
    }

    @Override
    public ISet<E> bottom() {
        return new Set();
    }

    @Override
    public boolean leq(ISet<E> one, ISet<E> other) {
        if (other == TOP) {
            return true;
        }
        if (one == TOP) {
            return false;
        }
        return other.getSet().containsAll(one.getSet());
    }

    @Override
    public ISet<E> glb(ISet<E> one, ISet<E> other) {
        if (other == TOP) {
            return one;
        }
        if (one == TOP) {
            return other;
        }
        return new Set(Set.Immutable.subtract(one.getSet(), (Set.Immutable)Set.Immutable.subtract(one.getSet(), other.getSet())));
    }

    @Override
    public ISet<E> lub(ISet<E> one, ISet<E> other) {
        if (one == TOP || other == TOP) {
            return this.top();
        }
        return new Set(Set.Immutable.union(one.getSet(), other.getSet()));
    }

    public static final class ISetImplementation
    implements ISet {
        private static IStrategoConstructor cons;

        public static void initializeConstructor(ITermFactory tf) {
            cons = tf.makeConstructor("SymbolicLargestSet", 0);
        }

        @Override
        public IStrategoConstructor getConstructor() {
            return cons != null ? cons : new StrategoConstructor(this.getName(), this.getSubtermCount());
        }

        public Set.Immutable getSet() {
            throw new SymbolicLargestSetException("Attempting to read symbolic set of all values");
        }
    }
}

