/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.graph;

import io.usethesource.capsule.BinaryRelation;
import io.usethesource.capsule.Set;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.metaborg.util.collection.Sets;
import org.metaborg.util.iterators.PeekingIterator;

public class Algorithms {
    public static <V> Iterable<V> topoSort(Collection<V> nodes, BinaryRelation.Immutable<V, V> edges) {
        HashSet<V> nodeSet = new HashSet<V>(nodes);
        return Algorithms.topoSort((HashSet)nodeSet.clone(), edges, nodeSet);
    }

    private static <V> Iterable<V> topoSort(Set<V> frontier, BinaryRelation.Immutable<V, V> edges, Set<V> subgraph) {
        ArrayList<V> result = new ArrayList<V>(subgraph.size());
        frontier.removeAll(edges.values());
        frontier.retainAll(subgraph);
        BinaryRelation.Transient mutRel = edges.asTransient();
        while (!frontier.isEmpty()) {
            V node = frontier.iterator().next();
            frontier.remove(node);
            result.add(node);
            for (Object rhs : mutRel.get(node)) {
                mutRel.__remove(node, rhs);
                if (mutRel.containsValue(rhs) || subgraph.contains(rhs)) continue;
                frontier.add(rhs);
            }
        }
        return result;
    }

    public static <V> Iterable<V> topoDeps(Collection<V> startNodes, BinaryRelation.Immutable<V, V> edges) {
        HashSet subgraph = new HashSet();
        HashSet<Object> toVisit = new HashSet<V>(startNodes);
        HashSet topoStartNodes = new HashSet();
        while (!toVisit.isEmpty()) {
            HashSet<V> visiting = toVisit;
            toVisit = new HashSet();
            for (Object node : visiting) {
                subgraph.add(node);
                Set.Immutable dependents = edges.get(node);
                if (dependents.isEmpty()) {
                    topoStartNodes.add(node);
                    continue;
                }
                for (Object dependent : dependents) {
                    if (subgraph.contains(dependent)) continue;
                    toVisit.add(dependent);
                }
            }
        }
        return Algorithms.topoSort(topoStartNodes, edges.inverse(), subgraph);
    }

    public static <N> Collection<Set<N>> topoSCCs(Collection<N> startNodes, Function<N, ? extends Set<N>> next) {
        int index = 0;
        HashMap nodeIndex = new HashMap();
        HashMap nodeLowlink = new HashMap(nodeIndex);
        ArrayDeque sccStack = new ArrayDeque();
        HashSet stackSet = new HashSet();
        ArrayDeque<Set<N>> sccs = new ArrayDeque<Set<N>>();
        for (N node : startNodes) {
            if (nodeIndex.get(node) != null) continue;
            index = Algorithms.sccStrongConnect(next, node, index, nodeIndex, nodeLowlink, sccStack, stackSet, sccs);
        }
        return Collections.unmodifiableCollection(sccs);
    }

    public static <N> Collection<Set<N>> revTopoSCCs(Function<N, ? extends Set<N>> prev, Collection<Set<N>> sccs) {
        ArrayDeque<Set<N>> revSCCs = new ArrayDeque<Set<N>>(sccs.size());
        PeekingIterator<Set<N>> iterator = new PeekingIterator<Set<N>>(sccs.iterator());
        while (iterator.hasNext()) {
            Set<Object> scc = iterator.next();
            if (scc.size() != 1) {
                assert (iterator.hasNext());
                N nextSCCsFirstNode = iterator.peek().iterator().next();
                Set<N> hasEdgeToNextSCCsFirstNode = prev.apply(nextSCCsFirstNode);
                Object node = Sets.intersection(hasEdgeToNextSCCsFirstNode, scc).iterator().next();
                HashSet<N> unvisited = new HashSet<N>(scc);
                ArrayDeque<N> visitingStack = new ArrayDeque<N>();
                ArrayDeque<N> revSCC = new ArrayDeque<N>();
                visitingStack.addLast(node);
                do {
                    node = visitingStack.getLast();
                    unvisited.remove(node);
                    HashSet<N> befores = new HashSet<N>(Sets.intersection(prev.apply(node), unvisited));
                    if (!befores.isEmpty()) {
                        visitingStack.addAll(befores);
                        unvisited.removeAll(Arrays.asList(befores.toArray()));
                        continue;
                    }
                    visitingStack.removeLast();
                    revSCC.addFirst(node);
                } while (!visitingStack.isEmpty());
                scc = Collections.unmodifiableSet(new LinkedHashSet(revSCC));
            }
            revSCCs.addFirst(scc);
        }
        return Collections.unmodifiableCollection(revSCCs);
    }

    private static <N> int sccStrongConnect(Function<N, ? extends Set<N>> next, N from, int index, HashMap<N, Integer> nodeIndex, HashMap<N, Integer> nodeLowlink, Deque<N> sccStack, Set<N> stackSet, Deque<Set<N>> sccs) {
        nodeIndex.put(from, index);
        nodeLowlink.put(from, index);
        ++index;
        int stackSetSizeBefore = stackSet.size();
        stackSet.add(from);
        for (N to : next.apply(from)) {
            if (nodeIndex.get(to) == null) {
                index = Algorithms.sccStrongConnect(next, to, index, nodeIndex, nodeLowlink, sccStack, stackSet, sccs);
                nodeLowlink.put(from, Integer.min(nodeLowlink.get(from), nodeLowlink.get(to)));
                continue;
            }
            if (!stackSet.contains(to)) continue;
            nodeLowlink.put(from, Integer.min(nodeLowlink.get(from), nodeIndex.get(to)));
        }
        sccStack.push(from);
        if (Objects.equals(nodeLowlink.get(from), nodeIndex.get(from))) {
            LinkedHashSet<N> scc = new LinkedHashSet<N>(2 * (stackSet.size() - stackSetSizeBefore));
            int i = stackSet.size();
            while (i > stackSetSizeBefore) {
                N node = sccStack.pop();
                stackSet.remove(node);
                scc.add(node);
                --i;
            }
            sccs.addFirst(Collections.unmodifiableSet(scc));
        }
        return index;
    }
}

