/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.controlflow;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mb.flowspec.controlflow.TransferFunctionAppl;
import org.spoofax.interpreter.terms.IStrategoTerm;

public final class ImmutableTransferFunctionAppl
extends TransferFunctionAppl {
    private final String moduleName;
    private final int offset;
    private final List<IStrategoTerm> otherArgs;
    private final int hashCode;

    private ImmutableTransferFunctionAppl(String moduleName, int offset, Iterable<? extends IStrategoTerm> otherArgs) {
        this.moduleName = Objects.requireNonNull(moduleName, "moduleName");
        this.offset = offset;
        this.otherArgs = ImmutableTransferFunctionAppl.createUnmodifiableList(false, ImmutableTransferFunctionAppl.createSafeList(otherArgs, true, false));
        this.hashCode = this.computeHashCode();
    }

    private ImmutableTransferFunctionAppl(ImmutableTransferFunctionAppl original, String moduleName, int offset, List<IStrategoTerm> otherArgs) {
        this.moduleName = moduleName;
        this.offset = offset;
        this.otherArgs = otherArgs;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public String moduleName() {
        return this.moduleName;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    protected List<IStrategoTerm> otherArgs() {
        return this.otherArgs;
    }

    public final ImmutableTransferFunctionAppl withModuleName(String value) {
        String newValue = Objects.requireNonNull(value, "moduleName");
        if (this.moduleName.equals(newValue)) {
            return this;
        }
        return new ImmutableTransferFunctionAppl(this, newValue, this.offset, this.otherArgs);
    }

    public final ImmutableTransferFunctionAppl withOffset(int value) {
        if (this.offset == value) {
            return this;
        }
        return new ImmutableTransferFunctionAppl(this, this.moduleName, value, this.otherArgs);
    }

    public final ImmutableTransferFunctionAppl withOtherArgs(IStrategoTerm ... elements) {
        List<IStrategoTerm> newValue = ImmutableTransferFunctionAppl.createUnmodifiableList(false, ImmutableTransferFunctionAppl.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableTransferFunctionAppl(this, this.moduleName, this.offset, newValue);
    }

    public final ImmutableTransferFunctionAppl withOtherArgs(Iterable<? extends IStrategoTerm> elements) {
        if (this.otherArgs == elements) {
            return this;
        }
        List<IStrategoTerm> newValue = ImmutableTransferFunctionAppl.createUnmodifiableList(false, ImmutableTransferFunctionAppl.createSafeList(elements, true, false));
        return new ImmutableTransferFunctionAppl(this, this.moduleName, this.offset, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTransferFunctionAppl && this.equalTo(0, (ImmutableTransferFunctionAppl)another);
    }

    private boolean equalTo(int synthetic, ImmutableTransferFunctionAppl another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.moduleName.equals(another.moduleName) && this.offset == another.offset && this.otherArgs.equals(another.otherArgs);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.moduleName.hashCode();
        h += (h << 5) + this.offset;
        h += (h << 5) + this.otherArgs.hashCode();
        return h;
    }

    public static ImmutableTransferFunctionAppl of(String moduleName, int offset, List<IStrategoTerm> otherArgs) {
        return ImmutableTransferFunctionAppl.of(moduleName, offset, otherArgs);
    }

    public static ImmutableTransferFunctionAppl of(String moduleName, int offset, Iterable<? extends IStrategoTerm> otherArgs) {
        return new ImmutableTransferFunctionAppl(moduleName, offset, otherArgs);
    }

    public static ImmutableTransferFunctionAppl copyOf(TransferFunctionAppl instance) {
        if (instance instanceof ImmutableTransferFunctionAppl) {
            return (ImmutableTransferFunctionAppl)instance;
        }
        return ImmutableTransferFunctionAppl.of(instance.moduleName(), instance.offset(), instance.otherArgs());
    }

    private Object readResolve() throws ObjectStreamException {
        return new ImmutableTransferFunctionAppl(this, this.moduleName, this.offset, this.otherArgs);
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }
}

