/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.controlflow;

import jakarta.annotation.Nullable;
import java.io.ObjectStreamException;
import java.util.Objects;
import mb.flowspec.controlflow.CFGNode;
import mb.flowspec.controlflow.ICFGNode;
import mb.flowspec.terms.TermIndex;
import org.spoofax.interpreter.terms.IStrategoList;

public final class ImmutableCFGNode
extends CFGNode {
    private final TermIndex index;
    @Nullable
    private final String cFGNodeName;
    private final ICFGNode.Kind kind;
    private final int hashCode;
    private volatile transient long lazyInitBitmap;
    private static final long ANNOTATIONS_LAZY_INIT_BIT = 1L;
    private transient IStrategoList annotations;
    private static final long serialVersionUID = 42L;

    private ImmutableCFGNode(TermIndex index, @Nullable String cFGNodeName, ICFGNode.Kind kind) {
        this.index = Objects.requireNonNull(index, "index");
        this.cFGNodeName = cFGNodeName;
        this.kind = Objects.requireNonNull(kind, "kind");
        this.hashCode = this.computeHashCode();
    }

    private ImmutableCFGNode(ImmutableCFGNode original, TermIndex index, @Nullable String cFGNodeName, ICFGNode.Kind kind) {
        this.index = index;
        this.cFGNodeName = cFGNodeName;
        this.kind = kind;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public TermIndex getIndex() {
        return this.index;
    }

    @Override
    @Nullable
    public String getCFGNodeName() {
        return this.cFGNodeName;
    }

    @Override
    public ICFGNode.Kind getKind() {
        return this.kind;
    }

    public final ImmutableCFGNode withIndex(TermIndex value) {
        if (this.index == value) {
            return this;
        }
        TermIndex newValue = Objects.requireNonNull(value, "index");
        return new ImmutableCFGNode(this, newValue, this.cFGNodeName, this.kind);
    }

    public final ImmutableCFGNode withCFGNodeName(@Nullable String value) {
        if (Objects.equals(this.cFGNodeName, value)) {
            return this;
        }
        return new ImmutableCFGNode(this, this.index, value, this.kind);
    }

    public final ImmutableCFGNode withKind(ICFGNode.Kind value) {
        ICFGNode.Kind newValue = Objects.requireNonNull(value, "kind");
        if (this.kind == newValue) {
            return this;
        }
        return new ImmutableCFGNode(this, this.index, this.cFGNodeName, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCFGNode && this.equalTo(0, (ImmutableCFGNode)another);
    }

    private boolean equalTo(int synthetic, ImmutableCFGNode another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.index.equals(another.index) && this.kind.equals(another.kind);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.index.hashCode();
        h += (h << 5) + this.kind.hashCode();
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStrategoList getAnnotations() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableCFGNode immutableCFGNode = this;
            synchronized (immutableCFGNode) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.annotations = Objects.requireNonNull(super.getAnnotations(), "annotations");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.annotations;
    }

    public static ImmutableCFGNode of(TermIndex index, @Nullable String cFGNodeName, ICFGNode.Kind kind) {
        return new ImmutableCFGNode(index, cFGNodeName, kind);
    }

    public static ImmutableCFGNode copyOf(CFGNode instance) {
        if (instance instanceof ImmutableCFGNode) {
            return (ImmutableCFGNode)instance;
        }
        return ImmutableCFGNode.of(instance.getIndex(), instance.getCFGNodeName(), instance.getKind());
    }

    private Object readResolve() throws ObjectStreamException {
        return new ImmutableCFGNode(this, this.index, this.cFGNodeName, this.kind);
    }
}

