/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgql.lang.ir;

import java.util.List;
import java.util.Set;
import oracle.pgql.lang.ir.CommonPathExpression;
import oracle.pgql.lang.ir.Direction;
import oracle.pgql.lang.ir.PathFindingGoal;
import oracle.pgql.lang.ir.PathMode;
import oracle.pgql.lang.ir.PgqlUtils;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryExpressionVisitor;
import oracle.pgql.lang.ir.QueryVariable;
import oracle.pgql.lang.ir.QueryVertex;
import oracle.pgql.lang.ir.VertexPairConnection;
import oracle.pgql.lang.ir.unnest.OneRowPerMatch;
import oracle.pgql.lang.ir.unnest.RowsPerMatch;

public class QueryPath
extends VertexPairConnection {
    private CommonPathExpression commonPathExpression;
    private long minHops;
    private long maxHops;
    private PathFindingGoal goal;
    private int kValue;
    private boolean withTies;
    private PathMode pathMode;
    private RowsPerMatch rowsPerMatch;

    public QueryPath(QueryVertex src, QueryVertex dst, String name, CommonPathExpression commonPathExpression, boolean anonymous, long minHops, long maxHops, PathFindingGoal goal, int kValue, boolean withTies, PathMode pathMode, Direction direction, RowsPerMatch rowsPerMatch) {
        super(src, dst, name, anonymous, direction);
        this.commonPathExpression = commonPathExpression;
        this.minHops = minHops;
        this.maxHops = maxHops;
        this.goal = goal;
        this.kValue = kValue;
        this.withTies = withTies;
        this.pathMode = pathMode;
        this.rowsPerMatch = rowsPerMatch;
    }

    public QueryPath(QueryVertex src, QueryVertex dst, String name, CommonPathExpression commonPathExpression, boolean anonymous, long minHops, long maxHops, PathFindingGoal goal, int kValue, boolean withTies, Direction direction, RowsPerMatch rowsPerMatch) {
        this(src, dst, name, commonPathExpression, anonymous, minHops, maxHops, goal, kValue, withTies, PathMode.WALK, direction, rowsPerMatch);
    }

    public QueryPath(QueryVertex src, QueryVertex dst, String name, CommonPathExpression commonPathExpression, boolean anonymous, long minHops, long maxHops, PathFindingGoal goal, int kValue, boolean withTies, Direction direction) {
        this(src, dst, name, commonPathExpression, anonymous, minHops, maxHops, goal, kValue, withTies, PathMode.WALK, direction, new OneRowPerMatch());
    }

    public String getPathExpressionName() {
        return this.commonPathExpression.getName();
    }

    public void setPathExpressionName() {
        this.commonPathExpression.setName(this.name);
    }

    public List<QueryVertex> getVertices() {
        return this.commonPathExpression.getVertices();
    }

    public void setVertices(List<QueryVertex> vertices) {
        this.commonPathExpression.setVertices(vertices);
    }

    public List<VertexPairConnection> getConnections() {
        return this.commonPathExpression.getConnections();
    }

    public void setConnections(List<VertexPairConnection> connections) {
        this.commonPathExpression.setConnections(connections);
    }

    public Set<QueryExpression> getConstraints() {
        return this.commonPathExpression.getConstraints();
    }

    public void setConstraints(Set<QueryExpression> contstraints) {
        this.commonPathExpression.setConstraints(contstraints);
    }

    public QueryExpression getCost() {
        return this.commonPathExpression.getCost();
    }

    public void setCost(QueryExpression cost) {
        this.commonPathExpression.setCost(cost);
    }

    public long getMinHops() {
        return this.minHops;
    }

    public void setMinHops(long minHops) {
        this.minHops = minHops;
    }

    public long getMaxHops() {
        return this.maxHops;
    }

    public void setMaxHops(long maxHops) {
        this.maxHops = maxHops;
    }

    public PathFindingGoal getPathFindingGoal() {
        return this.goal;
    }

    public void setPathFindingGoal(PathFindingGoal goal) {
        this.goal = goal;
    }

    public int getKValue() {
        return this.kValue;
    }

    public void setKValue(int kValue) {
        this.kValue = kValue;
    }

    public boolean getWithTies() {
        return this.withTies;
    }

    public void setWithTies(boolean withTies) {
        this.withTies = withTies;
    }

    public PathMode getPathMode() {
        return this.pathMode;
    }

    public void setPathMode(PathMode pathMode) {
        this.pathMode = pathMode;
    }

    @Override
    public QueryVariable.VariableType getVariableType() {
        return QueryVariable.VariableType.PATH;
    }

    public RowsPerMatch getRowsPerMatch() {
        return this.rowsPerMatch;
    }

    public void setRowsPerMatch(RowsPerMatch rowsPerMatch) {
        this.rowsPerMatch = rowsPerMatch;
    }

    public String toString() {
        switch (this.goal) {
            case REACHES: {
                if (this.commonPathExpression.getName().startsWith("<<anonymous>>_")) {
                    return this.printVariableLengthPathPattern(this.goal);
                }
                String path = "-/";
                if (!this.isAnonymous()) {
                    path = path + PgqlUtils.printIdentifier(this.name, false);
                }
                return path + ":" + PgqlUtils.printIdentifier(this.commonPathExpression.getName(), false) + PgqlUtils.printHops(this) + "/->";
            }
            case SHORTEST: 
            case CHEAPEST: 
            case ALL: {
                return this.printVariableLengthPathPattern(this.goal);
            }
        }
        throw new UnsupportedOperationException(this.goal.name());
    }

    private String printVariableLengthPathPattern(PathFindingGoal goal) {
        String pathPatternPrefix = null;
        switch (goal) {
            case REACHES: {
                pathPatternPrefix = "ANY ";
                break;
            }
            case ALL: {
                pathPatternPrefix = "ALL ";
                break;
            }
            case SHORTEST: 
            case CHEAPEST: {
                if (this.kValue == 1) {
                    pathPatternPrefix = (this.withTies ? "ALL " : "ANY ") + goal.toString() + " ";
                    break;
                }
                pathPatternPrefix = goal.toString() + " " + this.kValue + " ";
                break;
            }
            default: {
                new UnsupportedOperationException(goal.name());
            }
        }
        pathPatternPrefix = pathPatternPrefix + (this.pathMode == PathMode.WALK ? "" : this.pathMode.toString() + " ");
        String result = pathPatternPrefix + this.getSrc() + " ";
        String pathExpression = PgqlUtils.printPathExpression(this.commonPathExpression, true);
        result = pathExpression.contains("WHERE") || pathExpression.contains("COST") || pathExpression.startsWith("(") || pathExpression.endsWith(")") ? result + "(" + pathExpression + ")" : result + pathExpression;
        result = result + PgqlUtils.printHops(this) + " " + this.getDst();
        return result;
    }

    @Override
    public void accept(QueryExpressionVisitor v) {
        v.visit(this);
    }

    @Override
    public int hashCode() {
        return 31;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryPath other = (QueryPath)obj;
        if (this.commonPathExpression == null ? other.commonPathExpression != null : !this.commonPathExpression.equals(other.commonPathExpression)) {
            return false;
        }
        if (this.maxHops != other.maxHops) {
            return false;
        }
        if (this.minHops != other.minHops) {
            return false;
        }
        if (this.goal != other.goal) {
            return false;
        }
        if (this.kValue != other.kValue) {
            return false;
        }
        if (this.withTies != other.withTies) {
            return false;
        }
        if (!this.pathMode.equals((Object)other.pathMode)) {
            return false;
        }
        return this.rowsPerMatch.equals(other.rowsPerMatch);
    }
}

