/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgql.lang.ddl.propertygraph;

import java.util.List;
import java.util.stream.Collectors;
import oracle.pgql.lang.ddl.propertygraph.BaseGraph;
import oracle.pgql.lang.ddl.propertygraph.CreatePropertyGraph;
import oracle.pgql.lang.ddl.propertygraph.EdgeTable;
import oracle.pgql.lang.ddl.propertygraph.VertexTable;
import oracle.pgql.lang.ir.SchemaQualifiedName;
import oracle.pgql.lang.ir.StatementType;

public class CreateSuperPropertyGraph
extends CreatePropertyGraph {
    private List<BaseGraph> baseGraphs;

    public CreateSuperPropertyGraph(SchemaQualifiedName graphName, List<BaseGraph> baseGraphs, List<VertexTable> vertexTables, List<EdgeTable> edgeTables) {
        super(graphName, vertexTables, edgeTables);
        this.baseGraphs = baseGraphs;
    }

    public List<BaseGraph> getBaseGraphs() {
        return this.baseGraphs;
    }

    public void setBaseGraphs(List<BaseGraph> baseGraphs) {
        this.baseGraphs = baseGraphs;
    }

    @Override
    public String toString() {
        return "CREATE PROPERTY GRAPH " + this.graphName.toString(true) + "\n  BASE GRAPHS (\n    " + this.baseGraphs.stream().map(x -> x.toString()).collect(Collectors.joining(",\n    ")) + "\n  )" + this.printVertexTables() + this.printEdgeTables() + this.printOptions();
    }

    @Override
    public StatementType getStatementType() {
        return StatementType.CREATE_SUPER_PROPERTY_GRAPH;
    }

    @Override
    public int hashCode() {
        return 31;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CreateSuperPropertyGraph other = (CreateSuperPropertyGraph)obj;
        return !(this.baseGraphs == null ? other.baseGraphs != null : !this.baseGraphs.equals(other.baseGraphs));
    }
}

