/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import oracle.pgql.lang.ir.QueryExpression;

public class IntervalModule
extends SimpleModule {
    public IntervalModule() {
        super("IntervalModule", Version.unknownVersion());
        this.addSerializer(QueryExpression.Interval.class, new IntervalSerializer());
    }

    private class IntervalSerializer
    extends JsonSerializer<QueryExpression.Interval> {
        private IntervalSerializer() {
        }

        public void serialize(QueryExpression.Interval interval, JsonGenerator generator, SerializerProvider sprovider) throws IOException {
            QueryExpression.DateTimeField dateTimeField = interval.getSingleDateTimeField();
            generator.writeStartObject();
            generator.writeFieldName("value");
            generator.writeStartObject();
            generator.writeStringField("DateTimeField", dateTimeField.name());
            if (dateTimeField == QueryExpression.DateTimeField.SECOND) {
                generator.writeNumberField("duration", interval.getSecond());
            } else {
                generator.writeNumberField("duration", this.getValue(interval));
            }
            generator.writeEndObject();
            generator.writeStringField("expType", "INTERVAL");
            generator.writeEndObject();
        }

        private long getValue(QueryExpression.Interval interval) throws IOException {
            switch (interval.getSingleDateTimeField()) {
                case YEAR: {
                    return interval.getYear();
                }
                case MONTH: {
                    return interval.getMonth();
                }
                case DAY: {
                    return interval.getDay();
                }
                case HOUR: {
                    return interval.getHour();
                }
                case MINUTE: {
                    return interval.getMinute();
                }
                case SECOND: {
                    throw new IOException("getValue() can't have an interval of type SECOND as argument");
                }
            }
            throw new IOException("Interval is invalid");
        }
    }
}

