/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

import java.io.Console;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import oracle.pgx.common.util.AuthConsole;
import oracle.pgx.common.util.ErrorMessages;

public class AuthCertUtils {
    public static AuthConsole getSystemConsole() {
        Console sysConsole = System.console();
        if (sysConsole != null) {
            return new SystemAuthConsole(sysConsole);
        }
        return null;
    }

    public static char[] checkJksKeystorePassword(String keystorePath, AuthConsole console, boolean setKeyStoreProperties) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IllegalArgumentException, IllegalStateException {
        if (setKeyStoreProperties) {
            System.setProperty("javax.net.ssl.keyStore", keystorePath);
        }
        if (AuthCertUtils.testJksKeystorePassword(keystorePath, null)) {
            return null;
        }
        char[] password = AuthCertUtils.promptUserForPassword("enter password for keystore " + keystorePath, console);
        if (setKeyStoreProperties) {
            System.setProperty("javax.net.ssl.keyStorePassword", new String(password));
        }
        if (!AuthCertUtils.testJksKeystorePassword(keystorePath, password)) {
            throw new IllegalArgumentException(ErrorMessages.getMessage("INVALID_IDENTIFICATION", new Object[0]));
        }
        return password;
    }

    public static boolean testJksKeystorePassword(String keystorePath, char[] password) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, FileNotFoundException {
        try (FileInputStream fis = new FileInputStream(keystorePath);){
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(fis, password);
            Enumeration<String> aliases = ks.aliases();
            if (!aliases.hasMoreElements()) {
                throw new IOException(ErrorMessages.getMessage("EMPTY_KEYSTORE", new Object[0]));
            }
            String first = aliases.nextElement();
            ks.getKey(first, password);
        }
        catch (IOException e) {
            if (e.getCause() != null && e.getCause() instanceof UnrecoverableKeyException) {
                return false;
            }
            throw e;
        }
        catch (UnrecoverableKeyException e) {
            return false;
        }
        return true;
    }

    public static char[] promptUserForPassword(String message, AuthConsole console) throws UnsupportedOperationException {
        if (console == null) {
            throw new IllegalStateException(ErrorMessages.getMessage("NO_CONSOLE_AVAILABLE", new Object[0]));
        }
        String msg = message != null ? message : "password";
        console.printf("\n%s: ", msg);
        return console.readRedacted();
    }

    public static String getPasswordFromKeystore(String keystorePath, char[] password, String keystoreAlias) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, FileNotFoundException {
        try {
            KeyStore ks = AuthCertUtils.loadKeystore(keystorePath, password);
            if (!ks.containsAlias(keystoreAlias)) {
                throw new IllegalArgumentException(ErrorMessages.getMessage("INVALID_KEYSTORE_ALIAS", keystoreAlias));
            }
            byte[] bytes = ks.getKey(keystoreAlias, password).getEncoded();
            return new String(bytes);
        }
        catch (UnrecoverableKeyException e) {
            throw new IllegalArgumentException(ErrorMessages.getMessage("INVALID_IDENTIFICATION", new Object[0]));
        }
    }

    private static KeyStore loadKeystore(String keystorePath, char[] password) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, FileNotFoundException {
        KeyStore keyStore;
        FileInputStream fis = new FileInputStream(keystorePath);
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(fis, password);
            keyStore = ks;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                if (e.getCause() != null && e.getCause() instanceof UnrecoverableKeyException) {
                    throw new IllegalArgumentException(ErrorMessages.getMessage("INVALID_IDENTIFICATION", new Object[0]));
                }
                throw e;
            }
        }
        fis.close();
        return keyStore;
    }

    private static final class SystemAuthConsole
    implements AuthConsole {
        private Console sysConsole;

        SystemAuthConsole(Console console) throws IllegalArgumentException {
            if (console == null) {
                throw new IllegalArgumentException("console cannot be null");
            }
            this.sysConsole = console;
        }

        @Override
        public String readText() {
            return this.sysConsole.readLine();
        }

        @Override
        public char[] readRedacted() {
            return this.sysConsole.readPassword();
        }

        @Override
        public void printf(String format, Object ... args) {
            this.sysConsole.printf(format, args);
        }
    }
}

