/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import oracle.pgx.utils.IdGenerator;

public final class PgxId
implements Serializable {
    public static final PgxId VERTEX_LABELS_PROPERTY_ID = IdGenerator.generateIdFromString("VERTEX_LABELS");
    public static final PgxId EDGE_LABEL_PROPERTY_ID = IdGenerator.generateIdFromString("EDGE_LABEL");
    @JsonInclude
    private final UUID uuid;

    public PgxId(UUID uuid) {
        this.uuid = uuid;
    }

    @JsonValue
    public String toString() {
        return this.uuid.toString().toUpperCase();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PgxId pgxId = (PgxId)o;
        return Objects.equals(this.uuid, pgxId.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    @JsonCreator
    public static PgxId fromString(String value) {
        return value == null || value.isEmpty() ? null : new PgxId(UUID.fromString(value));
    }

    public static PgxId generateFromString(String value) {
        return value == null ? null : IdGenerator.generateIdFromString(value);
    }
}

