/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Objects;
import java.util.stream.Collectors;
import oracle.pgx.api.beta.annotation.BetaApi;
import oracle.pgx.api.keys.KeyUtils;
import oracle.pgx.common.types.IdType;

public class PartitionedId {
    private final String provider;
    private final Object[] keyValues;

    public PartitionedId(String provider, String key) {
        this(provider, new Object[]{key});
    }

    public PartitionedId(String provider, Object ... keyValues) {
        this.provider = provider;
        this.keyValues = keyValues;
        for (int i = 0; i < this.keyValues.length; ++i) {
            Object value = this.keyValues[i];
            if (value instanceof String) continue;
            this.keyValues[i] = value.toString();
        }
    }

    public String getTableName() {
        return this.provider;
    }

    public Object getKey(IdType type) {
        KeyUtils.assertHasOneKeyColumnLegacy(this.keyValues.length);
        return this.getKeyValue(0, type);
    }

    @BetaApi
    public Object getKeyValue(int index, IdType keyType) {
        String keyValue = this.keyValues[index].toString();
        switch (keyType) {
            case LONG: {
                return Long.parseLong(keyValue);
            }
            case INTEGER: {
                return Integer.parseInt(keyValue);
            }
            case STRING: {
                return keyValue;
            }
        }
        throw new UnsupportedOperationException("unsupported id type " + keyType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionedId that = (PartitionedId)o;
        return Objects.equals(this.provider, that.provider) && Arrays.equals(this.keyValues, that.keyValues);
    }

    public int hashCode() {
        int result = Objects.hash(this.provider);
        result = 31 * result + Arrays.hashCode(this.keyValues);
        return result;
    }

    public String toString() {
        return PartitionedId.createPartitionedId(this.provider, this.keyValues);
    }

    public static String createPartitionedId(String tableName, Object ... keyValues) {
        assert (keyValues.length > 0);
        return Arrays.stream(keyValues).map(Object::toString).map(PartitionedId::escapeIdPart).collect(Collectors.joining(",", PartitionedId.escapeIdPart(tableName) + '(', ")"));
    }

    private static String escapeIdPart(String s) {
        if (s.contains("\"") || s.contains("(") || s.contains(",") || s.contains(")")) {
            return '\"' + s.replace("\"", "\"\"") + '\"';
        }
        return s;
    }

    public static PartitionedId parse(String partitionedId) {
        int length = partitionedId.length();
        String providerName = PartitionedId.parseValue(partitionedId, 0, length);
        if (providerName == null || length == 0) {
            return null;
        }
        int providerNameLength = providerName.length() + (partitionedId.charAt(0) == '\"' ? 2 + PartitionedId.numDoubleQuotes(providerName) : 0);
        if (providerNameLength == length || partitionedId.charAt(providerNameLength) != '(' || partitionedId.charAt(length - 1) != ')') {
            return null;
        }
        LinkedList<String> keyValues = new LinkedList<String>();
        int startOfKey = providerNameLength + 1;
        while (startOfKey < length) {
            String nextKey = PartitionedId.parseValue(partitionedId, startOfKey, length);
            if (nextKey == null) {
                return null;
            }
            if (partitionedId.charAt(startOfKey) == '\"') {
                startOfKey += 2 + PartitionedId.numDoubleQuotes(nextKey);
            }
            keyValues.add(nextKey);
            if (partitionedId.charAt((startOfKey += nextKey.length() + 1) - 1) == (startOfKey == length ? (char)')' : ',')) continue;
            return null;
        }
        if (startOfKey != length) {
            return null;
        }
        assert (!keyValues.isEmpty());
        return new PartitionedId(providerName, keyValues.toArray());
    }

    private static String parseValue(String partitionedId, int begin, int length) {
        if (length == 0) {
            return "";
        }
        char c = partitionedId.charAt(begin);
        if (c == '\"') {
            int i = begin + 1;
            boolean done = false;
            while (!done && i < length) {
                if (partitionedId.charAt(i) == '\"') {
                    if (++i < length && partitionedId.charAt(i) == '\"') {
                        ++i;
                        continue;
                    }
                    done = true;
                    continue;
                }
                ++i;
            }
            if (partitionedId.charAt(i - 1) != '\"' || begin == i - 1) {
                return null;
            }
            String value = partitionedId.substring(begin + 1, i - 1).replace("\"\"", "\"");
            if (!(value.contains("\"") || value.contains("(") || value.contains(",") || value.contains(")"))) {
                return null;
            }
            return value;
        }
        int i = begin;
        while (c != '\"' && c != '(' && c != ',' && c != ')' && ++i != length) {
            c = partitionedId.charAt(i);
        }
        return partitionedId.substring(begin, i);
    }

    private static int numDoubleQuotes(String value) {
        return (int)value.chars().filter(c -> c == 34).count();
    }
}

