/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.graphviz.driver;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.ResultAccess;
import oracle.pgql.lang.ResultSet;
import oracle.pgql.lang.ResultSetMetaData;
import org.apache.commons.lang3.NotImplementedException;

public class ResultSetCache<T extends ResultAccess>
implements ResultSet<T> {
    private final ResultSet<T> delegate;
    private final Connection conn;
    private final List<List<Object>> cache;
    private final Map<String, Integer> indexMap;
    private int cursor;

    public ResultSetCache(ResultSet<T> delegate, Connection conn) throws PgqlException {
        this.delegate = delegate;
        this.conn = conn;
        this.cache = new ArrayList<List<Object>>();
        ResultSetMetaData metaData = delegate.getMetaData();
        int columnCount = metaData.getColumnCount();
        this.indexMap = new HashMap<String, Integer>();
        for (int j = 1; j <= columnCount; ++j) {
            this.indexMap.put(metaData.getColumnName(j), j);
        }
        int i = 0;
        while (delegate.next()) {
            ArrayList<Object> row = new ArrayList<Object>(columnCount);
            this.cache.add(row);
            for (int j = 1; j <= columnCount; ++j) {
                row.add(delegate.getObject(j));
            }
            ++i;
        }
        this.beforeFirst();
        delegate.close();
    }

    public int getNumResults() {
        return this.cache.size();
    }

    public boolean next() throws PgqlException {
        return this.valid(++this.cursor);
    }

    public boolean previous() throws PgqlException {
        return this.valid(--this.cursor);
    }

    public boolean first() throws PgqlException {
        this.cursor = 1;
        return this.valid(this.cursor);
    }

    public boolean last() throws PgqlException {
        this.cursor = this.cache.size();
        return this.valid(this.cursor);
    }

    public void beforeFirst() throws PgqlException {
        this.cursor = 0;
    }

    public void afterLast() throws PgqlException {
        this.cursor = this.cache.size() + 1;
    }

    public boolean absolute(long row) throws PgqlException {
        this.cursor = Math.toIntExact(row);
        return this.valid(this.cursor);
    }

    public boolean relative(long rows) throws PgqlException {
        this.cursor = Math.toIntExact((long)this.cursor + rows);
        return this.valid(this.cursor);
    }

    public void close() throws PgqlException {
        try {
            this.delegate.close();
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("failed trying to close the jdbc connection", e);
        }
    }

    public ResultSetMetaData getMetaData() throws PgqlException {
        return this.delegate.getMetaData();
    }

    public Object getObject(int elementIdx) throws PgqlException {
        return this.cache.get(this.cursor - 1).get(elementIdx - 1);
    }

    public Object getObject(String elementName) throws PgqlException {
        return this.getObject(this.indexMap.get(elementName));
    }

    public String getString(int elementIdx) throws PgqlException {
        return (String)this.getObject(elementIdx);
    }

    public String getString(String elementName) throws PgqlException {
        return this.getString(this.indexMap.get(elementName));
    }

    public Integer getInteger(int elementIdx) throws PgqlException {
        return (Integer)this.getObject(elementIdx);
    }

    public Integer getInteger(String elementName) throws PgqlException {
        return this.getInteger(this.indexMap.get(elementName));
    }

    public Long getLong(int elementIdx) throws PgqlException {
        return (Long)this.getObject(elementIdx);
    }

    public Long getLong(String elementName) throws PgqlException {
        return this.getLong(this.indexMap.get(elementName));
    }

    public Float getFloat(int elementIdx) throws PgqlException {
        return (Float)this.getObject(elementIdx);
    }

    public Float getFloat(String elementName) throws PgqlException {
        return this.getFloat(this.indexMap.get(elementName));
    }

    public Double getDouble(int elementIdx) throws PgqlException {
        return (Double)this.getObject(elementIdx);
    }

    public Double getDouble(String elementName) throws PgqlException {
        return this.getDouble(this.indexMap.get(elementName));
    }

    public Boolean getBoolean(int elementIdx) throws PgqlException {
        String booleanValue = (String)this.getObject(elementIdx);
        if ("Y".equals(booleanValue)) {
            return true;
        }
        return Boolean.parseBoolean(booleanValue);
    }

    public Boolean getBoolean(String elementName) throws PgqlException {
        return this.getBoolean(this.indexMap.get(elementName));
    }

    public Set<String> getVertexLabels(int elementIdx) throws PgqlException {
        return (Set)this.getObject(elementIdx);
    }

    public Set<String> getVertexLabels(String elementName) throws PgqlException {
        return this.getVertexLabels(this.indexMap.get(elementName));
    }

    public LocalDate getDate(int elementIdx) throws PgqlException {
        return (LocalDate)this.getObject(elementIdx);
    }

    public LocalDate getDate(String elementName) throws PgqlException {
        return this.getDate(this.indexMap.get(elementName));
    }

    public LocalTime getTime(int elementIdx) throws PgqlException {
        return (LocalTime)this.getObject(elementIdx);
    }

    public LocalTime getTime(String elementName) throws PgqlException {
        return this.getTime(this.indexMap.get(elementName));
    }

    public LocalDateTime getTimestamp(int elementIdx) throws PgqlException {
        return (LocalDateTime)this.getObject(elementIdx);
    }

    public LocalDateTime getTimestamp(String elementName) throws PgqlException {
        return this.getTimestamp(this.indexMap.get(elementName));
    }

    public OffsetTime getTimeWithTimezone(int elementIdx) throws PgqlException {
        return (OffsetTime)this.getObject(elementIdx);
    }

    public OffsetTime getTimeWithTimezone(String elementName) throws PgqlException {
        return this.getTimeWithTimezone(this.indexMap.get(elementName));
    }

    public OffsetDateTime getTimestampWithTimezone(int elementIdx) throws PgqlException {
        return (OffsetDateTime)this.getObject(elementIdx);
    }

    public OffsetDateTime getTimestampWithTimezone(String elementName) throws PgqlException {
        return this.getTimestampWithTimezone(this.indexMap.get(elementName));
    }

    public Date getLegacyDate(int elementIdx) throws PgqlException {
        return (Date)this.getObject(elementIdx);
    }

    public Date getLegacyDate(String elementName) throws PgqlException {
        return this.getLegacyDate(this.indexMap.get(elementName));
    }

    public List<T> getList(String elementName) throws PgqlException {
        return this.getList(this.indexMap.get(elementName));
    }

    public List<T> getList(int elementIdx) throws PgqlException {
        return (List)this.getObject(elementIdx);
    }

    private boolean valid(long cursore) {
        return 1L <= cursore && cursore <= (long)this.cache.size();
    }

    public Iterator<T> iterator() {
        throw new NotImplementedException("not implemented");
    }
}

