/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config.mllib.inputconfig;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeName;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.mllib.inputconfig.CategoricalEmbeddingType;
import oracle.pgx.config.mllib.inputconfig.CategoricalPropertyConfig;

@JsonTypeName(value="embedding_table_config")
public class EmbeddingTableConfig
extends CategoricalPropertyConfig {
    public static final Integer DEFAULT_EMBEDDING_DIM = null;
    public static final double DEFAULT_OOV_PROB = 0.0;
    private Integer embeddingDimension = DEFAULT_EMBEDDING_DIM;
    private double outOfVocabularyProbability = 0.0;

    public EmbeddingTableConfig(String propertyName) {
        super(propertyName, CategoricalEmbeddingType.EMBEDDING_TABLE);
    }

    public EmbeddingTableConfig(CategoricalPropertyConfig otherConfig) {
        super(otherConfig, CategoricalEmbeddingType.EMBEDDING_TABLE);
        if (otherConfig instanceof EmbeddingTableConfig) {
            this.embeddingDimension = ((EmbeddingTableConfig)otherConfig).getEmbeddingDimension();
            this.outOfVocabularyProbability = ((EmbeddingTableConfig)otherConfig).getOutOfVocabularyProbability();
        }
    }

    public Integer getEmbeddingDimension() {
        return this.embeddingDimension;
    }

    public void setEmbeddingDimension(Integer embeddingDimension) {
        this.embeddingDimension = embeddingDimension;
    }

    public double getOutOfVocabularyProbability() {
        return this.outOfVocabularyProbability;
    }

    public void setOutOfVocabularyProbability(double outOfVocabularyProbability) {
        this.outOfVocabularyProbability = outOfVocabularyProbability;
    }

    @Override
    @JsonIgnore
    public void validateProperties() {
        super.validateProperties();
        if (this.embeddingDimension != null && this.embeddingDimension <= 0) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_CATEG_EMBED_DIM", (Object[])new Object[]{this.embeddingDimension}));
        }
        if (this.outOfVocabularyProbability < 0.0 || this.outOfVocabularyProbability > 1.0) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_CATEG_OOV_PROB", (Object[])new Object[]{this.outOfVocabularyProbability}));
        }
    }
}

