/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config.internal;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import oracle.pgx.api.keys.ForeignKeyColumnDescriptor;
import oracle.pgx.api.keys.KeyColumnDescriptor;
import oracle.pgx.api.keys.KeyUtils;
import oracle.pgx.common.IllegalEnumConstantException;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.ConfigField;
import oracle.pgx.config.EntityProviderConfig;
import oracle.pgx.config.EsEntityProviderConfig;
import oracle.pgx.config.FileEntityProviderConfig;
import oracle.pgx.config.ProviderFormat;
import oracle.pgx.config.RdbmsEntityProviderConfig;

public class LegacyConfigUtils {
    private LegacyConfigUtils() {
    }

    public static void checkIfConfigHasLegacyKeyDeclaration(EntityProviderConfig providerConfig) {
        ProviderFormat format = (ProviderFormat)((Object)providerConfig.getFormat());
        ConfigField keyNameField = LegacyConfigUtils.getKeyNameField(format);
        Object keyName = providerConfig.getValues().getOrDefault(keyNameField, keyNameField.getDefaultVal());
        if (!Objects.equals(keyName, keyNameField.getDefaultVal())) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"BETA_CONFIG_USED_TOGETHER_WITH_UPDATED_CONFIG", (Object[])new Object[]{keyNameField, FileEntityProviderConfig.Field.KEY_COLUMNS}));
        }
        if (providerConfig.getKeyType() != LegacyConfigUtils.getDefaultKeyType(format)) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"BETA_CONFIG_USED_TOGETHER_WITH_UPDATED_CONFIG", (Object[])new Object[]{FileEntityProviderConfig.Field.KEY_TYPE, FileEntityProviderConfig.Field.KEY_COLUMNS}));
        }
    }

    public static List<KeyColumnDescriptor> extractKeyDeclarationFromLegacyConfig(EntityProviderConfig providerConfig) {
        ConfigField keyNameField = LegacyConfigUtils.getKeyNameField((ProviderFormat)((Object)providerConfig.getFormat()));
        Object keyColumn = providerConfig.getValues().getOrDefault(keyNameField, keyNameField.getDefaultVal());
        String keyColumnName = keyColumn == null ? "" : keyColumn.toString();
        return KeyUtils.createKeyDescriptors((String)keyColumnName, (IdType)providerConfig.getKeyType());
    }

    private static ConfigField getKeyNameField(ProviderFormat providerFormat) {
        ErrorMessages.requireNonNull((Object)((Object)providerFormat), (String)"provider format");
        switch (providerFormat) {
            case PGB: 
            case CSV: {
                return FileEntityProviderConfig.Field.KEY_COLUMN;
            }
            case RDBMS: {
                return RdbmsEntityProviderConfig.Field.KEY_COLUMN;
            }
            case ES: {
                return EsEntityProviderConfig.Field.KEY_FIELD;
            }
        }
        throw IllegalEnumConstantException.create((Enum)providerFormat, (Enum[])ProviderFormat.values());
    }

    public static IdType getDefaultKeyType(ProviderFormat providerFormat) {
        ErrorMessages.requireNonNull((Object)((Object)providerFormat), (String)"provider format");
        switch (providerFormat) {
            case PGB: 
            case CSV: {
                return (IdType)FileEntityProviderConfig.Field.KEY_TYPE.getDefaultVal();
            }
            case RDBMS: {
                return (IdType)RdbmsEntityProviderConfig.Field.KEY_TYPE.getDefaultVal();
            }
            case ES: {
                return (IdType)EsEntityProviderConfig.Field.KEY_TYPE.getDefaultVal();
            }
        }
        throw IllegalEnumConstantException.create((Enum)providerFormat, (Enum[])ProviderFormat.values());
    }

    public static List<? extends ForeignKeyColumnDescriptor> extractForeignKeyColumnsFromFields(EntityProviderConfig config, ConfigField legacyField, ConfigField foreignKeyField, List<? extends ForeignKeyColumnDescriptor> foreignKey) {
        String legacyValue;
        Object configDefaultValue = legacyField.getDefaultVal();
        Object legacyValueOrDefault = config.getValues().getOrDefault(legacyField, configDefaultValue);
        String string = legacyValue = legacyValueOrDefault == null ? null : legacyValueOrDefault.toString();
        if (foreignKey == null || foreignKey.isEmpty()) {
            if (legacyValue == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(ForeignKeyColumnDescriptor.of((String)legacyValue, null));
        }
        if (!LegacyConfigUtils.hasDefault(config, legacyField) && !Objects.equals(configDefaultValue, legacyValue)) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"BETA_CONFIG_USED_TOGETHER_WITH_UPDATED_CONFIG", (Object[])new Object[]{legacyField, foreignKeyField}));
        }
        KeyUtils.validateForeignKey(foreignKey);
        return foreignKey;
    }

    private static boolean hasDefault(EntityProviderConfig config, ConfigField field) {
        if (config instanceof FileEntityProviderConfig && field instanceof FileEntityProviderConfig.Field) {
            return ((FileEntityProviderConfig)config).hasDefaultValue((FileEntityProviderConfig.Field)field);
        }
        if (config instanceof RdbmsEntityProviderConfig && field instanceof RdbmsEntityProviderConfig.Field) {
            return ((RdbmsEntityProviderConfig)config).hasDefaultValue((RdbmsEntityProviderConfig.Field)field);
        }
        Object valueOrDefault = config.getValues().getOrDefault(field, field.getDefaultVal());
        return Objects.equals(valueOrDefault, field.getDefaultVal());
    }
}

