/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import oracle.pgx.common.types.EntityType;
import oracle.pgx.common.types.IdStrategy;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.StringUtils;
import oracle.pgx.config.AbstractConfig;
import oracle.pgx.config.CommonLoadableConfig;
import oracle.pgx.config.ExternalStoreConfig;
import oracle.pgx.config.Format;
import oracle.pgx.config.GraphLoadingConfig;
import oracle.pgx.config.GraphOptimizedFor;
import oracle.pgx.config.GraphPropertyConfig;
import oracle.pgx.config.PartitionWhileLoading;
import oracle.pgx.config.SnapshotsSource;
import oracle.pgx.config.internal.ConfigUtils;
import oracle.pgx.config.internal.ConvertibleToGraphConfigBuilder;

public abstract class GraphConfig
extends AbstractConfig
implements CommonLoadableConfig<Format>,
ConvertibleToGraphConfigBuilder {
    public static boolean isFileFormat(Format format) {
        return format.isFileFormat();
    }

    public static boolean hasVerticesAndEdgesSeparatedFileFormat(Format format) {
        return format.hasVerticesAndEdgesSeparatedFileFormat();
    }

    public static boolean isSingleFileFormat(Format format) {
        return !GraphConfig.hasVerticesAndEdgesSeparatedFileFormat(format);
    }

    public static boolean isMultipleFileFormat(Format format) {
        return GraphConfig.hasVerticesAndEdgesSeparatedFileFormat(format);
    }

    public static boolean supportsEdgeLabel(Format format) {
        return format.supportsEdgeLabel();
    }

    public static boolean supportsVertexLabels(Format format) {
        return format.supportsVertexLabels();
    }

    public static boolean supportsVectorProperties(Format format) {
        return format.supportsVectorProperties();
    }

    public static boolean supportsPropertyColumn(Format format) {
        return format.supportsPropertyColumn();
    }

    public abstract GraphOptimizedFor getOptimizedFor();

    public abstract PartitionWhileLoading getPartitionWhileLoading();

    public abstract List<GraphPropertyConfig> getVertexProps();

    public abstract List<GraphPropertyConfig> getEdgeProps();

    protected abstract IdStrategy getVertexIdStrategy();

    public IdStrategy getValidatedVertexIdStrategy() {
        boolean loadingKeys = this.isLoadVertexKeys();
        IdStrategy idStrategy = this.getVertexIdStrategy();
        return this.getValidatedIdStrategy(EntityType.VERTEX, loadingKeys, idStrategy);
    }

    public abstract IdType getVertexIdType();

    public IdType getValidatedVertexIdType() {
        IdType idType = this.getVertexIdType();
        return idType == null ? IdType.INTEGER : idType;
    }

    @Deprecated
    public abstract GraphLoadingConfig getLoading();

    public GraphLoadingConfig getLoadingOptions() {
        return this.getLoading();
    }

    public abstract List<ExternalStoreConfig> getExternalStores();

    public abstract Double getArrayCompactionThreshold();

    protected abstract IdStrategy getEdgeIdStrategy();

    public IdStrategy getValidatedEdgeIdStrategy() {
        boolean loadingKeys = this.isLoadEdgeKeys();
        IdStrategy idStrategy = this.getEdgeIdStrategy();
        return this.getValidatedIdStrategy(EntityType.EDGE, loadingKeys, idStrategy);
    }

    protected IdStrategy getValidatedIdStrategy(EntityType entityType, boolean loadingKeys, IdStrategy idStrategy) {
        return this.getValidatedIdStrategy(entityType, false, loadingKeys, idStrategy);
    }

    protected IdStrategy getValidatedIdStrategy(EntityType entityType, boolean byProvider, boolean loadingKeys, IdStrategy idStrategy) {
        IdStrategy validatedIdStrategy;
        if (idStrategy == null) {
            validatedIdStrategy = loadingKeys ? IdStrategy.KEYS_AS_IDS : IdStrategy.UNSTABLE_GENERATED_IDS;
        } else {
            if (loadingKeys && idStrategy == IdStrategy.UNSTABLE_GENERATED_IDS) {
                if (!byProvider) {
                    return this.throwConfigMismatchIdsAreNotGenerated(entityType, idStrategy);
                }
                return this.throwConfigMismatchIdsAreNotGeneratedByProvider(entityType, idStrategy);
            }
            if (!loadingKeys && idStrategy == IdStrategy.KEYS_AS_IDS) {
                if (!byProvider) {
                    return this.throwConfigMismatchKeysAreNotKept(entityType, idStrategy);
                }
                return this.throwConfigMismatchKeysAreNotKeptByProvider(entityType, idStrategy);
            }
            validatedIdStrategy = idStrategy;
        }
        return validatedIdStrategy;
    }

    private IdStrategy throwConfigMismatchKeysAreNotKept(EntityType entityType, IdStrategy idStrategy) {
        String unstableGeneratedIds = IdStrategy.UNSTABLE_GENERATED_IDS.toString().toLowerCase();
        return this.throwIdsConfigMismatch(entityType, ErrorMessages.getMessage((String)"CONFIG_MISMATCH_VERTEX_IDS", (Object[])new Object[]{idStrategy, false, true, unstableGeneratedIds}), ErrorMessages.getMessage((String)"CONFIG_MISMATCH_EDGE_IDS", (Object[])new Object[]{idStrategy, false, true, unstableGeneratedIds}));
    }

    private IdStrategy throwConfigMismatchIdsAreNotGenerated(EntityType entityType, IdStrategy idStrategy) {
        String keysAsIdsString = IdStrategy.KEYS_AS_IDS.toString().toLowerCase();
        return this.throwIdsConfigMismatch(entityType, ErrorMessages.getMessage((String)"CONFIG_MISMATCH_VERTEX_IDS", (Object[])new Object[]{idStrategy, true, false, keysAsIdsString}), ErrorMessages.getMessage((String)"CONFIG_MISMATCH_EDGE_IDS", (Object[])new Object[]{idStrategy, true, false, keysAsIdsString}));
    }

    private IdStrategy throwIdsConfigMismatch(EntityType entityType, String vertexMessage, String edgeMessage) {
        String message;
        switch (entityType) {
            case VERTEX: {
                message = vertexMessage;
                break;
            }
            case EDGE: {
                message = edgeMessage;
                break;
            }
            default: {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNSUPPORTED_ENTITY_TYPE", (Object[])new Object[]{entityType}));
            }
        }
        throw new IllegalArgumentException(message);
    }

    private IdStrategy throwConfigMismatchKeysAreNotKeptByProvider(EntityType entityType, IdStrategy idStrategy) {
        String unstableGeneratedIds = IdStrategy.UNSTABLE_GENERATED_IDS.toString().toLowerCase();
        return this.throwIdsConfigMismatchInProvider(entityType, idStrategy, ErrorMessages.getMessage((String)"CONFIG_MISMATCH_VERTEX_IDS_IN_SOME_PROVIDER", (Object[])new Object[]{idStrategy, false, true, unstableGeneratedIds}), ErrorMessages.getMessage((String)"CONFIG_MISMATCH_EDGE_IDS_IN_SOME_PROVIDER", (Object[])new Object[]{idStrategy, false, true, unstableGeneratedIds}));
    }

    private IdStrategy throwConfigMismatchIdsAreNotGeneratedByProvider(EntityType entityType, IdStrategy idStrategy) {
        String keysAsIdsString = IdStrategy.KEYS_AS_IDS.toString().toLowerCase();
        return this.throwIdsConfigMismatchInProvider(entityType, idStrategy, ErrorMessages.getMessage((String)"CONFIG_MISMATCH_VERTEX_IDS_IN_SOME_PROVIDER", (Object[])new Object[]{idStrategy, true, false, keysAsIdsString}), ErrorMessages.getMessage((String)"CONFIG_MISMATCH_EDGE_IDS_IN_SOME_PROVIDER", (Object[])new Object[]{idStrategy, true, false, keysAsIdsString}));
    }

    private IdStrategy throwIdsConfigMismatchInProvider(EntityType entityType, IdStrategy idStrategy, String vertexMessageKey, String edgeMessageKey) {
        String messageKey;
        switch (entityType) {
            case VERTEX: {
                messageKey = vertexMessageKey;
                break;
            }
            case EDGE: {
                messageKey = edgeMessageKey;
                break;
            }
            default: {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNSUPPORTED_ENTITY_TYPE", (Object[])new Object[]{entityType}));
            }
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage((String)messageKey, (Object[])new Object[]{idStrategy}));
    }

    public IdType getEdgeIdType() {
        return IdType.LONG;
    }

    public IdType getValidatedEdgeIdType() {
        IdType idType = this.getEdgeIdType();
        return idType == null ? IdType.LONG : idType;
    }

    public boolean isFileFormat() {
        return GraphConfig.isFileFormat((Format)((Object)this.getFormat()));
    }

    public boolean hasVerticesAndEdgesSeparatedFileFormat() {
        return GraphConfig.hasVerticesAndEdgesSeparatedFileFormat((Format)((Object)this.getFormat()));
    }

    public boolean isSingleFileFormat() {
        return !this.hasVerticesAndEdgesSeparatedFileFormat();
    }

    public boolean isMultipleFileFormat() {
        return this.hasVerticesAndEdgesSeparatedFileFormat();
    }

    public boolean supportsEdgeLabel() {
        return GraphConfig.supportsEdgeLabel((Format)((Object)this.getFormat()));
    }

    public boolean supportsVertexLabels() {
        return GraphConfig.supportsVertexLabels((Format)((Object)this.getFormat()));
    }

    public boolean supportsVectorProperties() {
        return GraphConfig.supportsVectorProperties((Format)((Object)this.getFormat()));
    }

    public boolean supportsPropertyColumn() {
        return GraphConfig.supportsPropertyColumn((Format)((Object)this.getFormat()));
    }

    public IdType getNodeKeyType() {
        return this.getVertexIdType();
    }

    public int numNodeProperties() {
        return this.getVertexProps().size();
    }

    public int numEdgeProperties() {
        return this.getEdgeProps().size();
    }

    public String getNodePropertyName(int i) {
        return this.getVertexProps().get(i).getName();
    }

    public String getEdgePropertyName(int i) {
        return this.getEdgeProps().get(i).getName();
    }

    public PropertyType getNodePropertyType(int i) {
        return this.getVertexProps().get(i).getType();
    }

    public PropertyType getEdgePropertyType(int i) {
        return this.getEdgeProps().get(i).getType();
    }

    public int getNodePropertyDimension(int i) {
        return this.getVertexProps().get(i).getDimension();
    }

    public int getEdgePropertyDimension(int i) {
        return this.getEdgeProps().get(i).getDimension();
    }

    public Object getNodePropertyDefault(int i) {
        return this.getVertexProps().get(i).getParsedDefaultValue();
    }

    public Object getEdgePropertyDefault(int i) {
        return this.getEdgeProps().get(i).getParsedDefaultValue();
    }

    public boolean isLoadEdgeKeys() {
        return this.getLoading().isCreateEdgeIdIndex() != false || this.getLoading().isCreateEdgeIdMapping() != false;
    }

    public boolean isLoadVertexKeys() {
        return this.getLoading().isCreateVertexIdIndex() != false || this.getLoading().isCreateVertexIdMapping() != false;
    }

    public boolean isVertexLabelsLoadingEnabled() {
        return this.getLoading().loadVertexLabels();
    }

    public boolean isEdgeLabelLoadingEnabled() {
        return this.getLoading().loadEdgeLabel();
    }

    public boolean skipVertexLoading() {
        return this.getLoading().skipVertices();
    }

    public boolean skipEdgeLoading() {
        return this.getLoading().skipEdges();
    }

    @Override
    protected void validate() {
        Format format;
        if (Objects.equals((Object)PartitionWhileLoading.BY_LABEL, (Object)this.getPartitionWhileLoading()) && (format = (Format)((Object)this.getFormat())) != null && !format.supportsPartitioningWhileLoading()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"PARTITIONING_WHILE_LOADING_NOT_SUPPORTED_BY_FORMAT", (Object[])new Object[]{format}));
        }
        this.validateUpdateOptimizedGraphParameters();
        this.getValidatedVertexIdStrategy();
        this.getValidatedEdgeIdStrategy();
        this.getValidatedVertexIdType();
        this.getValidatedEdgeIdType();
        this.validateProperties(this.getVertexProps());
        this.validateProperties(this.getEdgeProps());
        GraphLoadingConfig loadingConfig = this.getLoading();
        if (loadingConfig.isAutoRefresh().booleanValue()) {
            this.validateAutoRefreshParameters(loadingConfig);
        }
        if (loadingConfig.loadVertexLabels().booleanValue() && !this.supportsVertexLabels() && !((Format)((Object)this.getFormat())).supportsLoadingVertexLabelFromProperty()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"VERTEX_LABELS_NOT_SUPPORTED", (Object[])new Object[]{this.getFormat()}));
        }
        if (loadingConfig.loadEdgeLabel().booleanValue() && !this.supportsEdgeLabel()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"EDGE_LABEL_NOT_SUPPORTED", (Object[])new Object[]{this.getFormat()}));
        }
        if (loadingConfig.skipVertices().booleanValue() && !((Format)((Object)this.getFormat())).supportsSkippingVertices()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"SKIPPING_VERTICES_NOT_SUPPORTED", (Object[])new Object[]{this.getFormat()}));
        }
        if (loadingConfig.skipEdges().booleanValue() && !((Format)((Object)this.getFormat())).supportsSkippingEdges()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"SKIPPING_EDGES_NOT_SUPPORTED", (Object[])new Object[]{this.getFormat()}));
        }
        if (loadingConfig.skipVertices().booleanValue() && loadingConfig.skipEdges().booleanValue()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"CANNOT_SKIP_BOTH_EDGES_VERTICES", (Object[])new Object[0]));
        }
        if (StringUtils.isNotEmpty((String)loadingConfig.getUseVertexPropertyValueAsLabel()) && !((Format)((Object)this.getFormat())).supportsLoadingVertexLabelFromProperty()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"FORMAT_DOES_NOT_SUPPORT_READING_VERTEX_PROPS_AS_LABELS", (Object[])new Object[0]));
        }
        if (loadingConfig.isAutoRefresh().booleanValue() && SnapshotsSource.CHANGE_SET.equals((Object)loadingConfig.getSnapshotsSource())) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"CANNOT_AUTO_REFRESH_WITH_CHANGESETS", (Object[])new Object[0]));
        }
    }

    protected void validateUpdateOptimizedGraphParameters() {
        Double deltaArrayCompactionThreshold = this.getArrayCompactionThreshold();
        if (!(deltaArrayCompactionThreshold >= 0.0) || !(deltaArrayCompactionThreshold <= 1.0)) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"ARRAY_COMPACTION_THRESHOLD_OUT_OF_RANGE", (Object[])new Object[]{deltaArrayCompactionThreshold}));
        }
    }

    private void validateProperties(List<GraphPropertyConfig> props) {
        ConfigUtils.validateProperties(props, this.supportsVectorProperties(), this.supportsPropertyColumn(), true, ((Format)((Object)this.getFormat())).toString());
    }

    protected void validateAutoRefreshParameters(GraphLoadingConfig loadingConfig) {
        if (loadingConfig.getUpdateThreshold() != -1) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"CONFIG_FIELD_NOT_AVAILABLE", (Object[])new Object[]{GraphLoadingConfig.Field.UPDATE_THRESHOLD}));
        }
        if (loadingConfig.getFetchIntervalSec() != -1) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"CONFIG_FIELD_NOT_AVAILABLE", (Object[])new Object[]{GraphLoadingConfig.Field.FETCH_INTERVAL_SEC}));
        }
        if (loadingConfig.getUpdateIntervalSec() <= 0) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"NEGATIVE_INTERVAL", (Object[])new Object[]{GraphLoadingConfig.Field.UPDATE_INTERVAL_SEC}));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphConfig that = (GraphConfig)o;
        if (!Objects.equals(this.getFormat(), that.getFormat())) {
            return false;
        }
        if (!Objects.equals((Object)this.getPartitionWhileLoading(), (Object)that.getPartitionWhileLoading())) {
            return false;
        }
        if (!Objects.equals(this.getValidatedVertexIdStrategy(), that.getValidatedVertexIdStrategy())) {
            return false;
        }
        if (!Objects.equals(this.getValidatedEdgeIdStrategy(), that.getValidatedEdgeIdStrategy())) {
            return false;
        }
        if (!Objects.equals(this.getValidatedVertexIdType(), that.getValidatedVertexIdType())) {
            return false;
        }
        if (!Objects.equals(this.getLoading(), that.getLoading())) {
            return false;
        }
        if (!Objects.equals(this.getVertexProps(), that.getVertexProps())) {
            return false;
        }
        if (!Objects.equals(this.getEdgeProps(), that.getEdgeProps())) {
            return false;
        }
        return Objects.equals(this.getAttributes(), that.getAttributes());
    }

    public int hashCode() {
        int code;
        int n = code = this.getFormat() == null ? 0 : ((Format)((Object)this.getFormat())).hashCode();
        if (this.getPartitionWhileLoading() != null) {
            code += this.getPartitionWhileLoading().hashCode();
        }
        if (this.getValidatedVertexIdStrategy() != null) {
            code += this.getValidatedVertexIdStrategy().hashCode();
        }
        if (this.getValidatedEdgeIdStrategy() != null) {
            code += this.getValidatedEdgeIdStrategy().hashCode();
        }
        if (this.getValidatedVertexIdType() != null) {
            code += this.getValidatedVertexIdType().hashCode();
        }
        code += this.getLoading().isCreateVertexIdIndex().hashCode();
        code += this.getLoading().isCreateVertexIdMapping().hashCode();
        code += this.getLoading().isCreateEdgeIdIndex().hashCode();
        code += this.getLoading().isCreateEdgeIdMapping().hashCode();
        code += this.getLoading().loadVertexLabels().hashCode();
        code += this.getLoading().loadEdgeLabel().hashCode();
        code += this.getLoading().skipVertices().hashCode();
        code += this.getLoading().skipEdges().hashCode();
        for (GraphPropertyConfig prop : this.getVertexProps()) {
            code += prop.hashCode();
        }
        for (GraphPropertyConfig prop : this.getEdgeProps()) {
            code += prop.hashCode();
        }
        if (this.getAttributes() != null) {
            code += this.getAttributes().hashCode();
        }
        return code;
    }

    public Map<String, PropertyType> getVertexPropertyTypes() {
        return this.getPropertyTypes(this.getVertexProps());
    }

    public Map<String, PropertyType> getEdgePropertyTypes() {
        return this.getPropertyTypes(this.getEdgeProps());
    }

    private Map<String, PropertyType> getPropertyTypes(Iterable<GraphPropertyConfig> graphPropertyConfigs) {
        HashMap<String, PropertyType> propertyTypeMap = new HashMap<String, PropertyType>();
        graphPropertyConfigs.forEach(graphPropertyConfig -> propertyTypeMap.put(graphPropertyConfig.getName(), graphPropertyConfig.getType()));
        return propertyTypeMap;
    }
}

