/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.pgx.common.types.IdStrategy;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.AbstractGraphConfigFactory;
import oracle.pgx.config.FileGraphConfig;
import oracle.pgx.config.GraphConfig;
import oracle.pgx.config.GraphErrorHandlingConfig;
import oracle.pgx.config.GraphLoadingConfig;
import oracle.pgx.config.GraphOptimizedFor;
import oracle.pgx.config.GraphPropertyConfig;
import oracle.pgx.config.OnMismatch;
import oracle.pgx.config.OnMissingVertex;
import oracle.pgx.config.PartitionWhileLoading;
import oracle.pgx.config.SnapshotsSource;
import oracle.pgx.config.StringPoolingStrategy;
import oracle.pgx.config.internal.ConfigUtils;
import oracle.pgx.config.internal.ConvertibleToGraphConfigBuilder;

public abstract class AbstractGraphConfigBuilder<T extends AbstractGraphConfigBuilder<T, GC>, GC extends GraphConfig>
implements ConvertibleToGraphConfigBuilder {
    protected final Map<String, Object> values = new HashMap<String, Object>();
    private final List<Map<String, Object>> vertexProps = new LinkedList<Map<String, Object>>();
    private final List<Map<String, Object>> edgeProps = new LinkedList<Map<String, Object>>();
    protected final Map<String, Object> loadingValues = new HashMap<String, Object>();
    private final Map<String, Object> errorHandlingValues = new HashMap<String, Object>();
    private final Map<String, String> attributes = new HashMap<String, String>();

    public AbstractGraphConfigBuilder() {
        this.values.put(FileGraphConfig.Field.VERTEX_PROPS.toKey(), this.vertexProps);
        this.values.put(FileGraphConfig.Field.EDGE_PROPS.toKey(), this.edgeProps);
        this.values.put(FileGraphConfig.Field.LOADING.toKey(), this.loadingValues);
        this.values.put(FileGraphConfig.Field.ERROR_HANDLING.toKey(), this.errorHandlingValues);
        this.values.put(FileGraphConfig.Field.ATTRIBUTES.toKey(), this.attributes);
    }

    protected abstract AbstractGraphConfigFactory<GC> getFactory();

    protected T getThis() {
        return (T)this;
    }

    public T toGraphConfigBuilder() {
        return (T)this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GC build() {
        try (ByteArrayInputStream is = new ByteArrayInputStream(ConfigJsonUtil.writeValueAsBytes(this.values));){
            GraphConfig graphConfig = (GraphConfig)this.getFactory().fromInputStream(is);
            return (GC)graphConfig;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public T copyFrom(GC graphConfig) {
        return this.copyBaseFrom((GraphConfig)graphConfig);
    }

    public final T copyBaseFrom(GraphConfig graphConfig) {
        GraphOptimizedFor graphOptimizedFor;
        if (!this.values.containsKey(FileGraphConfig.Field.FORMAT.toKey())) {
            this.values.put(FileGraphConfig.Field.FORMAT.toKey(), graphConfig.getFormat());
        }
        if ((graphOptimizedFor = graphConfig.getOptimizedFor()) != null) {
            this.setOptimizedFor(graphOptimizedFor);
        }
        this.setArrayCompactionThreshold(graphConfig.getArrayCompactionThreshold());
        this.setVertexIdStrategy(graphConfig.getValidatedVertexIdStrategy());
        this.setEdgeIdStrategy(graphConfig.getValidatedEdgeIdStrategy());
        this.setVertexIdType(graphConfig.getVertexIdType());
        this.setEdgeIdType(graphConfig.getEdgeIdType());
        if (graphConfig.getPartitionWhileLoading() != null) {
            this.setPartitionWhileLoading(graphConfig.getPartitionWhileLoading());
        }
        if (graphConfig.getKeystoreAlias() != null) {
            this.setKeystoreAlias(graphConfig.getKeystoreAlias());
        }
        this.setLocalDateFormat(graphConfig.getLocalDateFormat());
        this.setTimeFormat(graphConfig.getTimeFormat());
        this.setTimestampFormat(graphConfig.getTimestampFormat());
        this.setTimeWithTimezoneFormat(graphConfig.getTimeWithTimezoneFormat());
        this.setTimestampWithTimezoneFormat(graphConfig.getTimestampWithTimezoneFormat());
        this.setErrorHandlingOnMissingVertex(graphConfig.getErrorHandling().getOnMissingVertex());
        graphConfig.getLoading().getValuesWithoutDefaults().forEach((key, value) -> this.loadingValues.put(key.toKey(), value));
        graphConfig.getErrorHandling().getValuesWithoutDefaults().forEach((key, value) -> this.errorHandlingValues.put(key.toKey(), value));
        graphConfig.getVertexProps().forEach(propConfig -> this.addVertexVectorProperty(propConfig.getName(), propConfig.getType(), propConfig.getDimension(), propConfig.getDefault(), propConfig.getColumn()));
        graphConfig.getEdgeProps().forEach(propConfig -> this.addEdgeVectorProperty(propConfig.getName(), propConfig.getType(), propConfig.getDimension(), propConfig.getDefault(), propConfig.getColumn()));
        graphConfig.getAttributes().forEach((key, value) -> this.addAttribute(String.valueOf(key), String.valueOf(value)));
        return this.getThis();
    }

    public T addNodeProperty(String name, PropertyType type, Object defaultVal) {
        return this.addVertexProperty(name, type, defaultVal);
    }

    public T addNodeProperty(String name, PropertyType type) {
        return this.addVertexProperty(name, type);
    }

    public T addVertexProperty(String name, PropertyType type, Object defaultVal) {
        return this.addVertexVectorProperty(name, type, 0, defaultVal);
    }

    public T addVertexStringProperty(String name, Object defaultVal, StringPoolingStrategy stringPoolingStrategy, Integer maxDistinctStringPerPool) {
        return this.addVertexStringProperty(name, 0, defaultVal, null, stringPoolingStrategy, maxDistinctStringPerPool);
    }

    public T addEdgeStringProperty(String name, Object defaultVal, StringPoolingStrategy stringPoolingStrategy, Integer maxDistinctStringPerPool) {
        return this.addEdgeStringProperty(name, 0, defaultVal, null, stringPoolingStrategy, maxDistinctStringPerPool);
    }

    public T addVertexProperty(String name, PropertyType type, Object defaultVal, Object column) {
        return this.addVertexVectorProperty(name, type, 0, defaultVal, column);
    }

    public T addVertexVectorProperty(String name, PropertyType type, int dimension, Object defaultVal) {
        return this.addVertexVectorProperty(name, type, dimension, defaultVal, null);
    }

    public T addVertexVectorProperty(String name, PropertyType type, int dimension, Object defaultVal, Object column) {
        this.vertexProps.add(this.createPropertyConfig(name, type, dimension, defaultVal, column));
        return this.getThis();
    }

    public T addVertexStringProperty(String name, int dimension, Object defaultVal, Object column, StringPoolingStrategy stringPoolingStrategy, Integer maxDistinctStringPerPool) {
        this.vertexProps.add(this.createStringPropertyConfig(name, dimension, defaultVal, column, stringPoolingStrategy, maxDistinctStringPerPool));
        return this.getThis();
    }

    public T addEdgeStringProperty(String name, int dimension, Object defaultVal, Object column, StringPoolingStrategy stringPoolingStrategy, Integer maxDistinctStringPerPool) {
        this.edgeProps.add(this.createStringPropertyConfig(name, dimension, defaultVal, column, stringPoolingStrategy, maxDistinctStringPerPool));
        return this.getThis();
    }

    public T addVertexProperty(String name, PropertyType type) {
        return this.addVertexProperty(name, type, null);
    }

    public T addVertexVectorProperty(String name, PropertyType type, int dimension) {
        return this.addVertexVectorProperty(name, type, dimension, null);
    }

    public T addEdgeProperty(String name, PropertyType type, Object defaultVal) {
        return this.addEdgeVectorProperty(name, type, 0, defaultVal);
    }

    public T addEdgeProperty(String name, PropertyType type, Object defaultVal, Object column) {
        return this.addEdgeVectorProperty(name, type, 0, defaultVal, column);
    }

    public T addEdgeVectorProperty(String name, PropertyType type, int dimension, Object defaultVal) {
        return this.addEdgeVectorProperty(name, type, dimension, defaultVal, null);
    }

    public T addEdgeVectorProperty(String name, PropertyType type, int dimension, Object defaultVal, Object column) {
        this.edgeProps.add(this.createPropertyConfig(name, type, dimension, defaultVal, column));
        return this.getThis();
    }

    public T addEdgeProperty(String name, PropertyType type) {
        return this.addEdgeProperty(name, type, null);
    }

    public T addEdgeVectorProperty(String name, PropertyType type, int dimension) {
        return this.addEdgeVectorProperty(name, type, dimension, null);
    }

    public T removeVertexProperty(String name) {
        this.vertexProps.removeIf(prop -> prop.get(GraphPropertyConfig.Field.NAME.toKey()).equals(name));
        return this.getThis();
    }

    public T removeEdgeProperty(String name) {
        this.edgeProps.removeIf(prop -> prop.get(GraphPropertyConfig.Field.NAME.toKey()).equals(name));
        return this.getThis();
    }

    public T clearVertexProperties() {
        this.vertexProps.clear();
        return this.getThis();
    }

    public T clearEdgeProperties() {
        this.edgeProps.clear();
        return this.getThis();
    }

    private Map<String, Object> createPropertyConfig(String name, PropertyType type, int dimension, Object defaultVal, Object column) {
        ConfigUtils.validateVectorPropertyType(type, dimension);
        HashMap<String, Object> propValues = new HashMap<String, Object>();
        propValues.put(GraphPropertyConfig.Field.NAME.toKey(), name);
        propValues.put(GraphPropertyConfig.Field.TYPE.toKey(), type.toString());
        propValues.put(GraphPropertyConfig.Field.DIMENSION.toKey(), dimension);
        propValues.put(GraphPropertyConfig.Field.DEFAULT.toKey(), defaultVal);
        propValues.put(GraphPropertyConfig.Field.COLUMN.toKey(), column);
        return propValues;
    }

    private Map<String, Object> createStringPropertyConfig(String name, int dimension, Object defaultVal, Object column, StringPoolingStrategy stringPoolingStrategy, Integer maxDistinctStringPerPool) {
        ConfigUtils.validateVectorPropertyType(PropertyType.STRING, dimension);
        HashMap<String, Object> propValues = new HashMap<String, Object>();
        propValues.put(GraphPropertyConfig.Field.NAME.toKey(), name);
        propValues.put(GraphPropertyConfig.Field.TYPE.toKey(), PropertyType.STRING.toString());
        propValues.put(GraphPropertyConfig.Field.DIMENSION.toKey(), dimension);
        propValues.put(GraphPropertyConfig.Field.DEFAULT.toKey(), defaultVal);
        propValues.put(GraphPropertyConfig.Field.COLUMN.toKey(), column);
        propValues.put(GraphPropertyConfig.Field.STRING_POOLING_STRATEGY.toKey(), (Object)stringPoolingStrategy);
        propValues.put(GraphPropertyConfig.Field.MAX_DISTINCT_STRINGS_PER_POOL.toKey(), maxDistinctStringPerPool);
        return propValues;
    }

    public T setOptimizedFor(GraphOptimizedFor strategy) {
        this.values.put(FileGraphConfig.Field.OPTIMIZED_FOR.toKey(), (Object)strategy);
        return this.getThis();
    }

    public T setPartitionWhileLoading(PartitionWhileLoading partitionWhileLoading) {
        this.values.put(FileGraphConfig.Field.PARTITION_WHILE_LOADING.toKey(), (Object)partitionWhileLoading);
        return this.getThis();
    }

    public T setPassword(String password) {
        this.values.put(FileGraphConfig.Field.PASSWORD.toKey(), password);
        return this.getThis();
    }

    public T setKeystoreAlias(String keystoreAlias) {
        this.values.put(FileGraphConfig.Field.KEYSTORE_ALIAS.toKey(), keystoreAlias);
        return this.getThis();
    }

    public T setArrayCompactionThreshold(Double arrayCompactionThreshold) {
        this.values.put(FileGraphConfig.Field.ARRAY_COMPACTION_THRESHOLD.toKey(), arrayCompactionThreshold);
        return this.getThis();
    }

    public T setVertexIdStrategy(IdStrategy idStrategy) {
        this.values.put(FileGraphConfig.Field.VERTEX_ID_STRATEGY.toKey(), idStrategy == null ? null : idStrategy.toString());
        return this.getThis();
    }

    public T setEdgeIdStrategy(IdStrategy idStrategy) {
        this.values.put(FileGraphConfig.Field.EDGE_ID_STRATEGY.toKey(), idStrategy == null ? null : idStrategy.toString());
        return this.getThis();
    }

    public T setVertexIdType(IdType vertexIdType) {
        this.values.put(FileGraphConfig.Field.VERTEX_ID_TYPE.toKey(), vertexIdType == null ? null : vertexIdType.toString());
        return this.getThis();
    }

    public T setEdgeIdType(IdType edgeIdType) {
        this.values.put(FileGraphConfig.Field.EDGE_ID_TYPE.toKey(), edgeIdType == null ? null : edgeIdType.toString());
        return this.getThis();
    }

    public T addAttribute(String key, String value) {
        this.attributes.put(key, value);
        return this.getThis();
    }

    public T setLocalDateFormat(List<String> localDateFormatList) {
        this.values.put(FileGraphConfig.Field.LOCAL_DATE_FORMAT.toKey(), localDateFormatList);
        return this.getThis();
    }

    public T setTimeFormat(List<String> timeFormatList) {
        this.values.put(FileGraphConfig.Field.TIME_FORMAT.toKey(), timeFormatList);
        return this.getThis();
    }

    public T setTimestampFormat(List<String> timestampFormatList) {
        this.values.put(FileGraphConfig.Field.TIMESTAMP_FORMAT.toKey(), timestampFormatList);
        return this.getThis();
    }

    public T setTimeWithTimezoneFormat(List<String> timeWithTimezoneFormatList) {
        this.values.put(FileGraphConfig.Field.TIME_WITH_TIMEZONE_FORMAT.toKey(), timeWithTimezoneFormatList);
        return this.getThis();
    }

    public T setTimestampWithTimezoneFormat(List<String> timestampWithTimezoneFormatList) {
        this.values.put(FileGraphConfig.Field.TIMESTAMP_WITH_TIMEZONE_FORMAT.toKey(), timestampWithTimezoneFormatList);
        return this.getThis();
    }

    public T setCreateLabelHistogram(boolean flag) {
        this.values.put(GraphLoadingConfig.Field.CREATE_LABEL_HISTOGRAM.toKey(), flag);
        return this.getThis();
    }

    public T setPartitionDiscardDefaultValues(boolean discardDefaultValues) {
        this.loadingValues.put(GraphLoadingConfig.Field.PARTITION_DISCARD_DEFAULT_VALUES.toKey(), discardDefaultValues);
        return this.getThis();
    }

    public T setFetchIntervalSec(int seconds) {
        this.loadingValues.put(GraphLoadingConfig.Field.FETCH_INTERVAL_SEC.toKey(), seconds);
        return this.getThis();
    }

    public T setUpdateIntervalSec(int seconds) {
        this.loadingValues.put(GraphLoadingConfig.Field.UPDATE_INTERVAL_SEC.toKey(), seconds);
        return this.getThis();
    }

    public T setAutoRefresh(boolean autoRefresh) {
        this.loadingValues.put(GraphLoadingConfig.Field.AUTO_REFRESH.toKey(), autoRefresh);
        return this.getThis();
    }

    public T setUpdateThreshold(int threshold) {
        this.loadingValues.put(GraphLoadingConfig.Field.UPDATE_THRESHOLD.toKey(), threshold);
        return this.getThis();
    }

    public T setLoadingProgressReportingFrequency(long frequency) {
        this.loadingValues.put(GraphLoadingConfig.Field.LOADING_PROGRESS_REPORTING_FREQUENCY.toKey(), frequency);
        return this.getThis();
    }

    public T setCreateVertexIdIndex(boolean create) {
        this.loadingValues.put(GraphLoadingConfig.Field.CREATE_VERTEX_ID_INDEX.toKey(), create);
        return this.getThis();
    }

    public T setCreateVertexIdMapping(boolean create) {
        this.loadingValues.put(GraphLoadingConfig.Field.CREATE_VERTEX_ID_MAPPING.toKey(), create);
        return this.getThis();
    }

    public T setCreateEdgeIdIndex(boolean create) {
        this.loadingValues.put(GraphLoadingConfig.Field.CREATE_EDGE_ID_INDEX.toKey(), create);
        return this.getThis();
    }

    public T setCreateEdgeIdMapping(boolean create) {
        this.loadingValues.put(GraphLoadingConfig.Field.CREATE_EDGE_ID_MAPPING.toKey(), create);
        return this.getThis();
    }

    public T setUpdatePropertiesInPlace(boolean updatePropertiesInPlace) {
        this.loadingValues.put(GraphLoadingConfig.Field.UPDATE_PROPERTIES_IN_PLACE.toKey(), updatePropertiesInPlace);
        return this.getThis();
    }

    public T setStrictMode(boolean strictMode) {
        this.loadingValues.put(GraphLoadingConfig.Field.STRICT_MODE.toKey(), strictMode);
        return this.getThis();
    }

    public T enableVertexIdDuplicateCheck(boolean checkVertexIdDuplicates) {
        this.errorHandlingValues.put(GraphErrorHandlingConfig.Field.ENABLE_VERTEX_ID_DUPLICATE_CHECK.toKey(), checkVertexIdDuplicates);
        return this.getThis();
    }

    public T enableEdgeIdDuplicateCheck(boolean checkEdgeIdDuplicates) {
        this.errorHandlingValues.put(GraphErrorHandlingConfig.Field.ENABLE_EDGE_ID_DUPLICATE_CHECK.toKey(), checkEdgeIdDuplicates);
        return this.getThis();
    }

    public T setErrorHandlingOnDuplicateEntityId(OnMismatch action) {
        this.errorHandlingValues.put(GraphErrorHandlingConfig.Field.ON_DUPLICATE_ENTITY_ID.toKey(), action.toKey());
        return this.getThis();
    }

    public T setErrorHandlingOnMissedPropKey(OnMismatch action) {
        this.errorHandlingValues.put(GraphErrorHandlingConfig.Field.ON_MISSED_PROP_KEY.toKey(), action.toKey());
        return this.getThis();
    }

    public T setErrorHandlingOnPropConversion(OnMismatch action) {
        this.errorHandlingValues.put(GraphErrorHandlingConfig.Field.ON_PROP_CONVERSION.toKey(), action.toKey());
        return this.getThis();
    }

    public T setErrorHandlingOnTypeMismatch(OnMismatch action) {
        this.errorHandlingValues.put(GraphErrorHandlingConfig.Field.ON_TYPE_MISMATCH.toKey(), action.toKey());
        return this.getThis();
    }

    public T setErrorHandlingOnMissingVertex(OnMissingVertex action) {
        this.errorHandlingValues.put(GraphErrorHandlingConfig.Field.ON_MISSING_VERTEX.toKey(), (Object)action);
        return this.getThis();
    }

    public T setErrorHandlingOnVectorLengthMismatch(OnMismatch action) {
        this.errorHandlingValues.put(GraphErrorHandlingConfig.Field.ON_VECTOR_LENGTH_MISMATCH.toKey(), (Object)action);
        return this.getThis();
    }

    public T setErrorHandlingOnParsingIssue(OnMismatch action) {
        this.errorHandlingValues.put(GraphErrorHandlingConfig.Field.ON_PARSING_ISSUE.toKey(), (Object)action);
        return this.getThis();
    }

    public T setLoadVertexLabels(boolean flag) {
        this.loadingValues.put(GraphLoadingConfig.Field.LOAD_VERTEX_LABELS.toKey(), flag);
        return this.getThis();
    }

    public T setLoadEdgeLabel(boolean flag) {
        this.loadingValues.put(GraphLoadingConfig.Field.LOAD_EDGE_LABEL.toKey(), flag);
        return this.getThis();
    }

    public T setUseVertexPropertyValueAsLabel(String labelPropertyName) {
        this.loadingValues.put(GraphLoadingConfig.Field.USE_VERTEX_PROPERTY_VALUE_AS_LABEL.toKey(), labelPropertyName);
        return this.getThis();
    }

    public T setPropertyValueDelimiter(String delimiter) {
        this.loadingValues.put(GraphLoadingConfig.Field.PROPERTY_VALUE_DELIMITER.toKey(), delimiter);
        return this.getThis();
    }

    public T setLabelValueDelimiter(String delimiter) {
        return this.setPropertyValueDelimiter(delimiter);
    }

    public T setSkipVertexLoading(boolean flag) {
        this.loadingValues.put(GraphLoadingConfig.Field.SKIP_VERTICES.toKey(), flag);
        return this.getThis();
    }

    public T setSkipEdgeLoading(boolean flag) {
        this.loadingValues.put(GraphLoadingConfig.Field.SKIP_EDGES.toKey(), flag);
        return this.getThis();
    }

    public T setSnapshotsSource(SnapshotsSource source) {
        this.loadingValues.put(GraphLoadingConfig.Field.SNAPSHOTS_SOURCE.toKey(), (Object)source);
        return this.getThis();
    }

    public T redactPassword() {
        if (this.values.get(FileGraphConfig.Field.PASSWORD.toKey()) != null) {
            this.setPassword("*******");
        }
        return this.getThis();
    }
}

