/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.stream.Stream;

public class RuntimeEnvironment {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Boolean containsLine(String path, String line) {
        try (Stream<String> stream = Files.lines(Paths.get(path, new String[0]));){
            Boolean bl = stream.anyMatch(test -> test.contains(line));
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static Boolean inContainer() {
        return RuntimeEnvironment.inDocker() != false || RuntimeEnvironment.inPodman() != false;
    }

    static Boolean inDocker() {
        return RuntimeEnvironment.containsLine("/proc/1/cgroup", "/docker");
    }

    static Boolean inPodman() {
        return RuntimeEnvironment.containsLine("/proc/1/environ", "container=podman");
    }

    static Boolean inWsl() {
        return RuntimeEnvironment.containsLine("/proc/1/environ", "container=wslcontainer_host_id");
    }

    @Deprecated
    public RuntimeEnvironment() {
    }
}

