/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

import java.util.function.Function;
import javax.annotation.Nonnull;
import oracle.pgx.api.admin.Control;
import oracle.pgx.api.internal.Core;
import oracle.pgx.common.util.InterfaceTracer;
import oracle.pgx.config.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CcTrace {
    private static final Logger LOG = LoggerFactory.getLogger(CcTrace.class);

    private CcTrace() {
    }

    public static <T extends Control> Function<T, Control> enableControlTracingIfConfigured(@Nonnull ClientConfig config) {
        return CcTrace.enableTracingIfConfigured(config, Control.class);
    }

    public static <T extends Core> Function<T, Core> enableCoreTracingIfConfigured(@Nonnull ClientConfig config) {
        return CcTrace.enableTracingIfConfigured(config, Core.class);
    }

    private static <I, T extends I> Function<T, I> enableTracingIfConfigured(@Nonnull ClientConfig config, Class<I> type) {
        return t -> {
            if (config.isEnableCctrace().booleanValue()) {
                LOG.trace("Enabling CCTrace for {} of type {}", t, (Object)type);
                return InterfaceTracer.getTracerFor(t, type, config.getCctraceOut(), config.isCctracePrintStacktraces());
            }
            return t;
        };
    }
}

