/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.marshalers;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import oracle.pgx.api.internal.Graph;
import oracle.pgx.api.internal.HomogeneousGraph;
import oracle.pgx.api.internal.compat.MetaDataCompatibilityVersion;
import oracle.pgx.common.marshalers.Marshaler;
import oracle.pgx.common.util.JsonUtil;
import oracle.pgx.common.util.SerializableVersion;

public class GraphResultMarshaler
implements Marshaler<Graph> {
    private final Class<? extends SerializableVersion> metaDataViewClass;

    public GraphResultMarshaler(MetaDataCompatibilityVersion metaDataVersion) {
        this.metaDataViewClass = metaDataVersion.getViewClass();
    }

    @Override
    public Graph unmarshal(String jsonString) throws JsonParseException, JsonMappingException, IOException {
        String sanitizedJson = JsonUtil.sanitize((String)jsonString);
        Graph response = (Graph)((Object)JsonUtil.readValue((String)sanitizedJson, Graph.class));
        if (response == null) {
            return null;
        }
        if (!response.isPartitioned()) {
            HomogeneousGraph simpleGraph = (HomogeneousGraph)((Object)JsonUtil.readValue((String)sanitizedJson, HomogeneousGraph.class));
            response = simpleGraph.getResult();
        }
        response.fixMetaData();
        return response;
    }

    @Override
    public String marshal(Graph object) throws JsonGenerationException, JsonMappingException, IOException {
        if (object != null && !object.isPartitioned()) {
            HomogeneousGraph wrappingHomogeneousGraph = new HomogeneousGraph(object);
            return JsonUtil.toJsonWithView((Object)((Object)wrappingHomogeneousGraph), this.metaDataViewClass);
        }
        return JsonUtil.toJsonWithView((Object)((Object)object), this.metaDataViewClass);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{viewClass=" + this.metaDataViewClass.getName() + "}";
    }
}

