/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.marshalers;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.RejectedExecutionException;
import javax.security.auth.login.LoginException;
import oracle.pgx.api.CompileException;
import oracle.pgx.api.MalformedProgramException;
import oracle.pgx.api.MalformedQueryException;
import oracle.pgx.api.PgxPgqlToSqlException;
import oracle.pgx.api.internal.ProxyException;
import oracle.pgx.common.NotFoundException;
import oracle.pgx.common.RemoteException;
import oracle.pgx.common.auth.AuthorizationException;
import oracle.pgx.common.marshalers.Marshaler;
import oracle.pgx.common.pojo.SerializedException;
import oracle.pgx.common.util.ChangeTrackingMap;
import oracle.pgx.common.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionMarshaler
implements Marshaler<Throwable> {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionMarshaler.class);

    private static SerializedException toSerializedException(Throwable t) {
        String message;
        String string = message = t == null ? null : t.getMessage();
        if (t instanceof RemoteException) {
            SerializedException.ErrorCode code = ExceptionMarshaler.getErrorCode(t.getCause());
            return new SerializedException(code, message, ((RemoteException)t).getCode());
        }
        SerializedException.ErrorCode code = ExceptionMarshaler.getErrorCode(t);
        return new SerializedException(code, message);
    }

    public static SerializedException.ErrorCode getErrorCode(Throwable t) {
        if (t instanceof IllegalArgumentException) {
            return SerializedException.ErrorCode.BAD_REQUEST;
        }
        if (t instanceof RejectedExecutionException) {
            return SerializedException.ErrorCode.REJECTED;
        }
        if (t instanceof CancellationException) {
            return SerializedException.ErrorCode.CANCELLED;
        }
        if (t instanceof UnsupportedOperationException) {
            return SerializedException.ErrorCode.UNSUPPORTED;
        }
        if (t instanceof ProxyException) {
            return SerializedException.ErrorCode.INVALID_RESULT;
        }
        if (t instanceof CompileException) {
            return SerializedException.ErrorCode.COMPILATION_ERROR;
        }
        if (t instanceof MalformedQueryException) {
            return SerializedException.ErrorCode.MALFORMED_QUERY;
        }
        if (t instanceof MalformedProgramException) {
            return SerializedException.ErrorCode.MALFORMED_PROGRAM;
        }
        if (t instanceof PgxPgqlToSqlException) {
            return SerializedException.ErrorCode.PGQL_TO_SQL_PROCESSING_ERROR;
        }
        if (t instanceof IllegalStateException) {
            return SerializedException.ErrorCode.ILLEGAL_STATE;
        }
        if (t instanceof NotFoundException) {
            return SerializedException.ErrorCode.NOT_FOUND;
        }
        if (t instanceof NoSuchElementException) {
            return SerializedException.ErrorCode.NOT_FOUND;
        }
        if (t instanceof ChangeTrackingMap.ChangeTrackingException) {
            return SerializedException.ErrorCode.CHANGE_TRACKING_EXCEPTION;
        }
        if (t instanceof LoginException) {
            return SerializedException.ErrorCode.UNAUTHORIZED;
        }
        if (t instanceof AuthorizationException) {
            return SerializedException.ErrorCode.FORBIDDEN;
        }
        return SerializedException.ErrorCode.INTERNAL_ENGINE_EXCEPTION;
    }

    public static Throwable toUnserializedException(SerializedException.ErrorCode code, String message) {
        LOG.debug("code: {}, message: {}", (Object)code, (Object)message);
        switch (code) {
            case BAD_REQUEST: {
                return new IllegalArgumentException(message);
            }
            case REJECTED: {
                return new RejectedExecutionException(message);
            }
            case CANCELLED: {
                return new CancellationException(message);
            }
            case UNSUPPORTED: {
                return new UnsupportedOperationException(message);
            }
            case INVALID_RESULT: {
                return new ProxyException(message);
            }
            case COMPILATION_ERROR: {
                return new CompileException(message);
            }
            case MALFORMED_QUERY: {
                return new MalformedQueryException(message);
            }
            case PGQL_TO_SQL_PROCESSING_ERROR: {
                return new PgxPgqlToSqlException(message);
            }
            case MALFORMED_PROGRAM: {
                return new MalformedProgramException(message);
            }
            case NOT_FOUND: {
                return new NotFoundException(message);
            }
            case ILLEGAL_STATE: {
                return new IllegalStateException(message);
            }
            case CHANGE_TRACKING_EXCEPTION: {
                return new ChangeTrackingMap.ChangeTrackingException(message, null);
            }
            case UNAUTHORIZED: {
                return new LoginException(message);
            }
            case FORBIDDEN: {
                return new AuthorizationException(message);
            }
        }
        return new Exception(message);
    }

    @Override
    public String marshal(Throwable t) throws IOException {
        SerializedException se = ExceptionMarshaler.toSerializedException(t);
        return JsonUtil.toJson((Object)se);
    }

    @Override
    public Throwable unmarshal(String content) throws IOException {
        SerializedException se = (SerializedException)JsonUtil.readTopLevelJson((String)content, SerializedException.class);
        return ExceptionMarshaler.toUnserializedException(se.code, se.message);
    }
}

