/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal.synchronizer;

import java.util.List;
import oracle.pgx.api.internal.synchronizer.FlashbackPropertyConfig;
import oracle.pgx.common.util.SqlSanitizationUtils;

public final class FlashbackConfig {
    private final Long startScn;
    private final Long lastScn;
    private final String graphName;
    private final String username;
    private final String databaseTableName;
    private final Integer dop;
    private final String keyColumn;
    private final String sourceColumn;
    private final String destinationColumn;
    private final List<FlashbackPropertyConfig> properties;
    private final String schema;
    public static final String DEFAULT_PARALLEL_HINT = "AUTO";

    public FlashbackConfig(Long startScn, Long lastScn, String graphName, String username, Integer dop, String databaseTableName, List<FlashbackPropertyConfig> properties, String keyColumn, String sourceColumn, String destinationColumn, String schema) {
        this.lastScn = lastScn;
        this.startScn = startScn;
        this.graphName = graphName;
        this.username = username;
        this.dop = dop;
        this.properties = properties;
        this.databaseTableName = databaseTableName;
        this.keyColumn = keyColumn;
        this.destinationColumn = destinationColumn;
        this.sourceColumn = sourceColumn;
        this.schema = schema;
    }

    public int getDop() {
        return this.dop;
    }

    public String getGraphName() {
        return this.graphName;
    }

    public Long getLastScn() {
        return this.lastScn;
    }

    public Long getStartScn() {
        return this.startScn;
    }

    public String getUsername() {
        return this.username;
    }

    public String getDatabaseTableName() {
        return this.databaseTableName;
    }

    public String getKeyColumn() {
        return this.keyColumn;
    }

    public String getDestinationColumn() {
        return this.destinationColumn;
    }

    public String getSourceColumn() {
        return this.sourceColumn;
    }

    public List<FlashbackPropertyConfig> getProperties() {
        return this.properties;
    }

    public String getSchema() {
        return this.schema;
    }

    public String printTableName() {
        if (this.schema != null && !this.schema.isEmpty()) {
            return SqlSanitizationUtils.quoteOracleUserName((String)this.schema) + "." + SqlSanitizationUtils.quoteIdentifier((String)this.databaseTableName);
        }
        return SqlSanitizationUtils.quoteIdentifier((String)this.databaseTableName);
    }

    public String getParallelHint() {
        return this.dop != null ? this.dop.toString() : DEFAULT_PARALLEL_HINT;
    }
}

