/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import oracle.pgx.api.internal.FrontierRedactionDescriptor;
import oracle.pgx.api.internal.PropertyDescriptor;

public class RedactionRulesTriggers
implements Serializable {
    private final HashMap<String, String> vertexPropertiesToRedactAndTriggers;
    private final HashMap<String, String> edgesPropertiesToRedactAndTriggers;
    private final String fullVertexRedactionTrigger;
    private final String fullEdgeRedactionTrigger;
    public static String newVertexVariableName = "a";
    private HashMap<String, String> vertexNameToFullVertexRedactionTrigger = new HashMap();
    private final Collection<PropertyDescriptor> allVertexProperties;
    private final Collection<PropertyDescriptor> allEdgeProperties;
    private final FrontierRedactionDescriptor frontierRedactionDescriptor;

    public RedactionRulesTriggers() {
        this.vertexPropertiesToRedactAndTriggers = new HashMap();
        this.edgesPropertiesToRedactAndTriggers = new HashMap();
        this.fullVertexRedactionTrigger = null;
        this.fullEdgeRedactionTrigger = null;
        this.vertexNameToFullVertexRedactionTrigger = new HashMap();
        this.allVertexProperties = new ArrayList<PropertyDescriptor>();
        this.allEdgeProperties = new ArrayList<PropertyDescriptor>();
        this.frontierRedactionDescriptor = null;
    }

    public RedactionRulesTriggers(HashMap<String, String> vertexPropertiesToRedactAndTriggers, HashMap<String, String> edgesPropertiesToRedactAndTriggers, String fullVertexRedactionTrigger, String fullEdgeRedactionTrigger, String fullVertexRedactionTriggerWithNewVertexName, Collection<PropertyDescriptor> allVertexProperties, Collection<PropertyDescriptor> allEdgeProperties, FrontierRedactionDescriptor frontierRedactionDescriptor) {
        this.vertexPropertiesToRedactAndTriggers = vertexPropertiesToRedactAndTriggers;
        this.edgesPropertiesToRedactAndTriggers = edgesPropertiesToRedactAndTriggers;
        this.fullVertexRedactionTrigger = fullVertexRedactionTrigger;
        this.fullEdgeRedactionTrigger = fullEdgeRedactionTrigger;
        this.vertexNameToFullVertexRedactionTrigger.put(newVertexVariableName, fullVertexRedactionTriggerWithNewVertexName);
        this.allVertexProperties = allVertexProperties;
        this.allEdgeProperties = allEdgeProperties;
        this.frontierRedactionDescriptor = frontierRedactionDescriptor;
    }

    public HashMap<String, String> getVertexPropertiesToRedactAndTriggers() {
        return this.vertexPropertiesToRedactAndTriggers;
    }

    public HashMap<String, String> getEdgesPropertiesToRedactAndTriggers() {
        return this.edgesPropertiesToRedactAndTriggers;
    }

    public String getFullVertexRedactionTrigger() {
        return this.fullVertexRedactionTrigger;
    }

    public String getFullEdgeRedactionTrigger() {
        return this.fullEdgeRedactionTrigger;
    }

    public HashMap<String, String> getVertexNameToFullVertexRedactionTrigger() {
        return this.vertexNameToFullVertexRedactionTrigger;
    }

    public Collection<PropertyDescriptor> getAllVertexProperties() {
        return this.allVertexProperties;
    }

    public Collection<PropertyDescriptor> getAllEdgeProperties() {
        return this.allEdgeProperties;
    }

    public List<String> getVerticesPropertiesNames() {
        return this.getVerticesOrEdgesPropertiesNames(this.allVertexProperties);
    }

    public List<String> getEdgesPropertiesNames() {
        return this.getVerticesOrEdgesPropertiesNames(this.allEdgeProperties);
    }

    private List<String> getVerticesOrEdgesPropertiesNames(Collection<PropertyDescriptor> properties) {
        ArrayList<String> propertiesNamesList = new ArrayList<String>();
        for (PropertyDescriptor property : properties) {
            propertiesNamesList.add(property.getPropertyName());
        }
        return propertiesNamesList;
    }

    public FrontierRedactionDescriptor getFrontierRedactionDescriptor() {
        return this.frontierRedactionDescriptor;
    }
}

