/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.frames.schema.internal.dispatchers.numeric;

import java.util.function.Function;
import oracle.pgx.api.frames.schema.datatypes.numeric.DoubleType;
import oracle.pgx.api.frames.schema.datatypes.numeric.FloatType;
import oracle.pgx.api.frames.schema.datatypes.numeric.IntegerType;
import oracle.pgx.api.frames.schema.datatypes.numeric.LongType;
import oracle.pgx.api.frames.schema.datatypes.numeric.NumericType;
import oracle.pgx.api.frames.schema.internal.dispatchers.DataTypeDispatcher;
import oracle.pgx.api.frames.schema.internal.dispatchers.numeric.DoubleTypeDispatcher;
import oracle.pgx.api.frames.schema.internal.dispatchers.numeric.FloatTypeDispatcher;
import oracle.pgx.api.frames.schema.internal.dispatchers.numeric.IntegerTypeDispatcher;
import oracle.pgx.api.frames.schema.internal.dispatchers.numeric.LongTypeDispatcher;

public interface NumericTypeDispatcher<R>
extends Function<NumericType, R> {
    public static <R> NumericTypeDispatcher<R> dispatcher(final IntegerTypeDispatcher<R> integerTypeDispatcher, final LongTypeDispatcher<R> longTypeDispatcher, final FloatTypeDispatcher<R> floatTypeDispatcher, final DoubleTypeDispatcher<R> doubleTypeDispatcher) {
        return new DefaultNumericTypeDispatcher<R>(){

            @Override
            public R applyIntegerType(IntegerType type) {
                return DataTypeDispatcher.applyType(integerTypeDispatcher, type);
            }

            @Override
            public R applyLongType(LongType type) {
                return DataTypeDispatcher.applyType(longTypeDispatcher, type);
            }

            @Override
            public R applyFloatType(FloatType type) {
                return DataTypeDispatcher.applyType(floatTypeDispatcher, type);
            }

            @Override
            public R applyDoubleType(DoubleType type) {
                return DataTypeDispatcher.applyType(doubleTypeDispatcher, type);
            }
        };
    }

    public static <R> R dispatch(IntegerTypeDispatcher<R> integerTypeDispatcher, LongTypeDispatcher<R> longTypeDispatcher, FloatTypeDispatcher<R> floatTypeDispatcher, DoubleTypeDispatcher<R> doubleTypeDispatcher, NumericType dataType) {
        return NumericTypeDispatcher.dispatcher(integerTypeDispatcher, longTypeDispatcher, floatTypeDispatcher, doubleTypeDispatcher).apply(dataType);
    }

    public static interface DefaultNumericTypeDispatcher<R>
    extends NumericTypeDispatcher<R> {
        @Override
        default public R apply(NumericType dataType) {
            if (dataType instanceof IntegerType) {
                return (R)DataTypeDispatcher.applyType(this::applyIntegerType, (IntegerType)dataType);
            }
            if (dataType instanceof LongType) {
                return (R)DataTypeDispatcher.applyType(this::applyLongType, (LongType)dataType);
            }
            if (dataType instanceof FloatType) {
                return (R)DataTypeDispatcher.applyType(this::applyFloatType, (FloatType)dataType);
            }
            if (dataType instanceof DoubleType) {
                return (R)DataTypeDispatcher.applyType(this::applyDoubleType, (DoubleType)dataType);
            }
            return (R)DataTypeDispatcher.throwNoDispatcherForType(dataType);
        }

        default public R applyIntegerType(IntegerType type) {
            return (R)DataTypeDispatcher.throwNoDispatcherForType(type);
        }

        default public R applyLongType(LongType type) {
            return (R)DataTypeDispatcher.throwNoDispatcherForType(type);
        }

        default public R applyFloatType(FloatType type) {
            return (R)DataTypeDispatcher.throwNoDispatcherForType(type);
        }

        default public R applyDoubleType(DoubleType type) {
            return (R)DataTypeDispatcher.throwNoDispatcherForType(type);
        }
    }
}

