/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.frames.schema.internal.dispatchers.collection;

import java.util.function.Function;
import oracle.pgx.api.frames.schema.datatypes.DataType;
import oracle.pgx.api.frames.schema.datatypes.StringType;
import oracle.pgx.api.frames.schema.datatypes.collection.SetType;
import oracle.pgx.api.frames.schema.datatypes.numeric.LongType;
import oracle.pgx.api.frames.schema.internal.dispatchers.DataTypeDispatcher;
import oracle.pgx.api.frames.schema.internal.dispatchers.StringTypeDispatcher;
import oracle.pgx.api.frames.schema.internal.dispatchers.numeric.LongTypeDispatcher;

@FunctionalInterface
public interface SetTypeDispatcher<R>
extends Function<SetType, R> {
    public static <R> SetTypeDispatcher<R> dispatcher(final StringTypeDispatcher<R> stringTypeDispatcher, final LongTypeDispatcher<R> longTypeDispatcher) {
        return new DefaultSetTypeDispatcher<R>(){

            @Override
            public R applyStringType(StringType type) {
                return DataTypeDispatcher.applyType(stringTypeDispatcher, type);
            }

            @Override
            public R applyLongType(LongType type) {
                return DataTypeDispatcher.applyType(longTypeDispatcher, type);
            }
        };
    }

    public static <R> R dispatch(StringTypeDispatcher<R> stringTypeDispatcher, LongTypeDispatcher<R> longTypeDispatcher, SetType dataType) {
        return SetTypeDispatcher.dispatcher(stringTypeDispatcher, longTypeDispatcher).apply(dataType);
    }

    public static interface DefaultSetTypeDispatcher<R>
    extends SetTypeDispatcher<R> {
        @Override
        default public R apply(SetType dataType) {
            DataType valueType = dataType.getValueType();
            if (valueType instanceof StringType) {
                return (R)DataTypeDispatcher.applyType(this::applyStringType, (StringType)valueType);
            }
            if (valueType instanceof LongType) {
                return (R)DataTypeDispatcher.applyType(this::applyLongType, (LongType)valueType);
            }
            return (R)DataTypeDispatcher.throwNoDispatcherForType(dataType);
        }

        default public R applyStringType(StringType type) {
            return (R)DataTypeDispatcher.throwNoDispatcherForType(type);
        }

        default public R applyLongType(LongType type) {
            return (R)DataTypeDispatcher.throwNoDispatcherForType(type);
        }
    }
}

