/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.frames.schema.datatypes;

import java.util.EnumMap;
import java.util.Map;
import oracle.pgx.api.frames.schema.datatypes.BooleanType;
import oracle.pgx.api.frames.schema.datatypes.DataType;
import oracle.pgx.api.frames.schema.datatypes.StringType;
import oracle.pgx.api.frames.schema.datatypes.collection.SetType;
import oracle.pgx.api.frames.schema.datatypes.collection.VectorType;
import oracle.pgx.api.frames.schema.datatypes.graph.EdgeType;
import oracle.pgx.api.frames.schema.datatypes.graph.VertexType;
import oracle.pgx.api.frames.schema.datatypes.numeric.DoubleType;
import oracle.pgx.api.frames.schema.datatypes.numeric.FloatType;
import oracle.pgx.api.frames.schema.datatypes.numeric.IntegerType;
import oracle.pgx.api.frames.schema.datatypes.numeric.LongType;
import oracle.pgx.api.frames.schema.datatypes.spatial.Point2dType;
import oracle.pgx.api.frames.schema.datatypes.temporal.LocalDateType;
import oracle.pgx.api.frames.schema.datatypes.temporal.TimeType;
import oracle.pgx.api.frames.schema.datatypes.temporal.TimeWithTimezoneType;
import oracle.pgx.api.frames.schema.datatypes.temporal.TimestampType;
import oracle.pgx.api.frames.schema.datatypes.temporal.TimestampWithTimezoneType;
import oracle.pgx.common.types.PropertyType;

public final class DataTypes {
    public static final BooleanType BOOLEAN_TYPE = new BooleanType();
    public static final StringType STRING_TYPE = new StringType();
    public static final VertexType VERTEX_TYPE = new VertexType();
    public static final EdgeType EDGE_TYPE = new EdgeType();
    public static final IntegerType INTEGER_TYPE = new IntegerType();
    public static final LongType LONG_TYPE = new LongType();
    public static final FloatType FLOAT_TYPE = new FloatType();
    public static final DoubleType DOUBLE_TYPE = new DoubleType();
    public static final Point2dType POINT2D_TYPE = new Point2dType();
    public static final LocalDateType LOCAL_DATE_TYPE = new LocalDateType();
    public static final TimestampType TIMESTAMP_TYPE = new TimestampType();
    public static final TimestampWithTimezoneType TIMESTAMP_WITH_TIMEZONE_TYPE = new TimestampWithTimezoneType();
    public static final TimeType TIME_TYPE = new TimeType();
    public static final TimeWithTimezoneType TIME_WITH_TIMEZONE_TYPE = new TimeWithTimezoneType();
    private static final Map<PropertyType, DataType> PROPERTY_TYPE_TO_DATA_TYPE = new EnumMap<PropertyType, DataType>(PropertyType.class);

    public static DataType getDataTypeFromPropertyType(PropertyType propertyType) {
        return PROPERTY_TYPE_TO_DATA_TYPE.get(propertyType);
    }

    private DataTypes() {
    }

    public static VectorType vector(DataType componentType, int dimension) {
        return new VectorType(componentType, dimension);
    }

    public static SetType set(DataType valueType) {
        return new SetType(valueType);
    }

    static {
        PROPERTY_TYPE_TO_DATA_TYPE.put(PropertyType.INTEGER, INTEGER_TYPE);
        PROPERTY_TYPE_TO_DATA_TYPE.put(PropertyType.LONG, LONG_TYPE);
        PROPERTY_TYPE_TO_DATA_TYPE.put(PropertyType.DOUBLE, DOUBLE_TYPE);
        PROPERTY_TYPE_TO_DATA_TYPE.put(PropertyType.STRING, STRING_TYPE);
        PROPERTY_TYPE_TO_DATA_TYPE.put(PropertyType.BOOLEAN, BOOLEAN_TYPE);
        PROPERTY_TYPE_TO_DATA_TYPE.put(PropertyType.VERTEX, VERTEX_TYPE);
        PROPERTY_TYPE_TO_DATA_TYPE.put(PropertyType.EDGE, EDGE_TYPE);
        PROPERTY_TYPE_TO_DATA_TYPE.put(PropertyType.FLOAT, FLOAT_TYPE);
        PROPERTY_TYPE_TO_DATA_TYPE.put(PropertyType.POINT2D, POINT2D_TYPE);
        PROPERTY_TYPE_TO_DATA_TYPE.put(PropertyType.LOCAL_DATE, LOCAL_DATE_TYPE);
        PROPERTY_TYPE_TO_DATA_TYPE.put(PropertyType.TIMESTAMP, TIMESTAMP_TYPE);
        PROPERTY_TYPE_TO_DATA_TYPE.put(PropertyType.TIMESTAMP_WITH_TIMEZONE, TIMESTAMP_WITH_TIMEZONE_TYPE);
        PROPERTY_TYPE_TO_DATA_TYPE.put(PropertyType.TIME, TIME_TYPE);
        PROPERTY_TYPE_TO_DATA_TYPE.put(PropertyType.TIME_WITH_TIMEZONE, TIME_WITH_TIMEZONE_TYPE);
    }
}

