/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.pgx.api.EntityProviderMetaData;
import oracle.pgx.api.PropertyMetaData;
import oracle.pgx.api.internal.compat.MetaDataCompatibilityVersion;
import oracle.pgx.api.keys.DefaultKeyColumnDescriptors;
import oracle.pgx.api.keys.KeyColumnDescriptor;
import oracle.pgx.common.types.IdType;

public class VertexProviderMetaData
extends EntityProviderMetaData {
    private final Set<String> edgeProviderNamesWhereSource;
    private final Set<String> edgeProviderNamesWhereDestination;

    @JsonCreator
    public VertexProviderMetaData(@JsonProperty(value="name") String name, @JsonProperty(value="key") List<KeyColumnDescriptor> key, @JsonProperty(value="labels") Set<String> labels, @JsonProperty(value="properties") List<PropertyMetaData> properties, @JsonProperty(value="edgeProviderNamesWhereSource") Set<String> edgeProviderNamesWhereSource, @JsonProperty(value="edgeProviderNamesWhereDestination") Set<String> edgeProviderNamesWhereDestination) {
        super(name, key, labels, properties);
        this.edgeProviderNamesWhereSource = new HashSet<String>(edgeProviderNamesWhereSource);
        this.edgeProviderNamesWhereDestination = new HashSet<String>(edgeProviderNamesWhereDestination);
    }

    @Deprecated
    public VertexProviderMetaData(String name, IdType idType, Set<String> labels, List<PropertyMetaData> properties, Set<String> edgeProviderNamesWhereSource, Set<String> edgeProviderNamesWhereDestination) {
        this(name, Collections.singletonList(DefaultKeyColumnDescriptors.forIdType((IdType)idType)), labels, properties, edgeProviderNamesWhereSource, edgeProviderNamesWhereDestination);
    }

    public VertexProviderMetaData(VertexProviderMetaData other) {
        super(other);
        this.edgeProviderNamesWhereSource = new HashSet<String>(other.edgeProviderNamesWhereSource);
        this.edgeProviderNamesWhereDestination = new HashSet<String>(other.edgeProviderNamesWhereDestination);
    }

    @JsonView(value={MetaDataCompatibilityVersion.Legacy25Dot1.class})
    public Set<String> getEdgeProviderNamesWhereSource() {
        return Collections.unmodifiableSet(this.edgeProviderNamesWhereSource);
    }

    @JsonView(value={MetaDataCompatibilityVersion.Legacy25Dot1.class})
    public Set<String> getEdgeProviderNamesWhereDestination() {
        return Collections.unmodifiableSet(this.edgeProviderNamesWhereDestination);
    }

    @Override
    public String toString() {
        return "VertexProviderMetaData [name=" + this.name + ", key=" + this.getKeyColumns() + "]";
    }
}

