/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.sqlpgq;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import oracle.pg.rdbms.sqlpgq.exception.SqlPgqVisualizationException;
import oracle.pgx.graphviz.formatter.Table;
import oracle.pgx.graphviz.formatter.TableException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlPgqResultSetTable
implements Table {
    private static final Logger LOG = LoggerFactory.getLogger(SqlPgqResultSetTable.class);
    @Nonnull
    private final ResultSet rs;
    @Nonnull
    private final List<String> header;

    public SqlPgqResultSetTable(@Nonnull ResultSet rs, @Nonnull List<String> header) {
        this.rs = rs;
        this.header = header;
    }

    private Object getObject(int idx) {
        try {
            Object object = this.rs.getObject(idx);
            if (object instanceof InputStream) {
                InputStream inputStream = (InputStream)object;
                return IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            }
            return this.rs.getObject(idx);
        }
        catch (IOException | SQLException e) {
            throw new SqlPgqVisualizationException(e);
        }
    }

    public ResultSet getResultSet() {
        return this.rs;
    }

    @Nonnull
    public List<String> getHeader() {
        return this.header;
    }

    @Nonnull
    public Iterable<List<Object>> getRows() {
        return () -> new Iterator<List<Object>>(){
            @Nullable
            Boolean hasNext = null;
            int numCols = SqlPgqResultSetTable.this.getHeader().size();

            @Override
            public boolean hasNext() {
                if (this.hasNext == null) {
                    try {
                        this.hasNext = SqlPgqResultSetTable.this.rs.next();
                    }
                    catch (SQLException e) {
                        this.hasNext = false;
                    }
                }
                if (!this.hasNext.booleanValue()) {
                    try {
                        if (!SqlPgqResultSetTable.this.rs.isClosed()) {
                            SqlPgqResultSetTable.this.rs.close();
                        }
                    }
                    catch (Exception e) {
                        LOG.info(e.getMessage());
                    }
                }
                return this.hasNext;
            }

            @Override
            @Nonnull
            public List<Object> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.hasNext = null;
                return IntStream.range(1, this.numCols + 1).mapToObj(idx -> SqlPgqResultSetTable.this.getObject(idx)).collect(Collectors.toList());
            }
        };
    }

    public boolean isResultSetClosed() throws SQLException {
        return this.rs.isClosed();
    }

    public int getRow() throws SQLException {
        return this.rs.getRow();
    }

    public void closeResultSet() throws TableException {
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (SQLException e) {
                throw new TableException((Throwable)e);
            }
        }
    }
}

