/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.sqlpgq;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import oracle.pg.rdbms.sqlpgq.EdgeTable;
import oracle.pg.rdbms.sqlpgq.SqlPgqMetadataUtils;
import oracle.pg.rdbms.sqlpgq.SqlPgqQueryGenerator;
import oracle.pg.rdbms.sqlpgq.VertexTable;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlPgqMetadata {
    private static final Logger LOG = LoggerFactory.getLogger(SqlPgqMetadata.class);
    private static final String GRAPHVIZ_PREFIX = "$GRAPHVIZ_TEMP_TABLE";
    private final Connection conn;
    private final String originalQuery;
    private final String viewName;
    private final String materializedViewName;
    private String graphName;
    private String graphOwner;
    private List<String> originalHeader = new ArrayList<String>();
    private Set<String> allVertexProperties = new HashSet<String>();
    private Set<String> allEdgeProperties = new HashSet<String>();
    private Map<String, VertexTable> vertexInformation = new HashMap<String, VertexTable>();
    private Map<String, EdgeTable> edgeTable = new HashMap<String, EdgeTable>();
    private Map<String, String> vertexQueries = new HashMap<String, String>();
    private Map<String, String> edgeQueries = new HashMap<String, String>();
    private long size;

    public SqlPgqMetadata(String originalQuery, Connection conn) {
        this.originalQuery = originalQuery;
        this.conn = conn;
        this.viewName = String.format("%s_%s", GRAPHVIZ_PREFIX, UUID.randomUUID().toString().substring(0, 22));
        this.materializedViewName = String.format("%s_%s", GRAPHVIZ_PREFIX, UUID.randomUUID().toString().substring(0, 22));
        this.size = 0L;
    }

    public boolean isVisualizable() {
        return this.vertexQueries.size() > 0 || this.edgeQueries.size() > 0;
    }

    @Nonnull
    public String getGraphName() {
        return this.graphName;
    }

    @Nonnull
    public String getGraphSchemaName() {
        return this.graphOwner;
    }

    public String getOriginalQuery() {
        return this.originalQuery;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public String getViewName() {
        return this.viewName;
    }

    public String getMaterializedViewName() {
        return this.materializedViewName;
    }

    public List<String> getOriginalHeader() {
        return this.originalHeader;
    }

    public Map<String, VertexTable> getVertexTables() {
        return this.vertexInformation;
    }

    public Map<String, EdgeTable> getEdgeTables() {
        return this.edgeTable;
    }

    public Set<String> getAllVertexProperties() {
        return this.allVertexProperties;
    }

    public Set<String> getAllEdgeProperties() {
        return this.allEdgeProperties;
    }

    public Map<String, String> getVertexQueries() {
        return this.vertexQueries;
    }

    public Map<String, String> getEdgeQueries() {
        return this.edgeQueries;
    }

    public void addVertexQuery(String vertexName, String query) {
        this.vertexQueries.put(vertexName, query);
    }

    public void addEdgeQuery(String edgeName, String query) {
        this.edgeQueries.put(edgeName, query);
    }

    public long getSize() {
        return this.size;
    }

    private void fillMetadata() throws SQLException {
        SqlPgqMetadataUtils utils = new SqlPgqMetadataUtils(this.graphName, this.graphOwner, this.conn);
        this.allVertexProperties = utils.getAllVertexProperties();
        this.vertexInformation = utils.getVertexTables();
        this.edgeTable = utils.getEdgeTables();
        this.allEdgeProperties = utils.getAllEdgeProperties();
    }

    private void setSize() throws SQLException {
        try (Statement statement = this.conn.createStatement();){
            ResultSet rs = statement.executeQuery(SqlPgqQueryGenerator.generateCountQuery(this));
            if (rs.next()) {
                this.size = rs.getLong(1);
            }
        }
    }

    public void createMaterializedView() throws SQLException {
        try (Statement statement = this.conn.createStatement();){
            String createViewQuery = SqlPgqQueryGenerator.generateCreateViewStatement(this);
            statement.execute(createViewQuery);
            String createMaterializedView = SqlPgqQueryGenerator.generateCreateMaterializedView(this);
            statement.execute(createMaterializedView);
        }
    }

    public void dropViewAndMaterializedView() throws SQLException {
        try (Statement statement = this.conn.createStatement();){
            int result;
            String checkIfMaterializedViewExistsQuery = SqlPgqQueryGenerator.generateCheckIfMaterializedViewExists(this);
            ResultSet resultSet = statement.executeQuery(checkIfMaterializedViewExistsQuery);
            if (resultSet.next() && (result = resultSet.getInt(1)) > 0) {
                String dropMaterializedView = SqlPgqQueryGenerator.dropMaterializedView(this);
                statement.execute(dropMaterializedView);
                String dropView = SqlPgqQueryGenerator.dropView(this);
                statement.execute(dropView);
            }
        }
    }

    private void generateVertexOrEdgeQuery(String columnName, String tableName) {
        Set vertexTableNames = this.vertexInformation.values().stream().map(p -> p.getTableAlias()).collect(Collectors.toSet());
        Set<String> edgeTableNames = this.edgeTable.keySet();
        if (vertexTableNames.contains(tableName)) {
            LOG.debug("Vertex table name {}", (Object)tableName);
            String generatedVertexQuery = SqlPgqQueryGenerator.generateVertexQuery(columnName, this);
            this.vertexQueries.put(columnName, generatedVertexQuery);
        } else if (edgeTableNames.contains(tableName)) {
            LOG.debug("Edge table name {}", (Object)tableName);
            String generatedEdgeQuery = SqlPgqQueryGenerator.generateEdgeQuery(columnName, this);
            LOG.debug("Edge query {}", (Object)generatedEdgeQuery);
            this.edgeQueries.put(columnName, generatedEdgeQuery);
        } else {
            LOG.debug("Variable is not vertex or edge ID");
        }
    }

    public void createVertexAndEdgeQueries() throws SQLException {
        ObjectMapper mapper = new ObjectMapper();
        try (Statement statement = this.conn.createStatement();){
            String selectAll = SqlPgqQueryGenerator.generateSelectQueryAgainstOriginalResultSet(this);
            ResultSet resultSetOriginalQuery = statement.executeQuery(selectAll);
            boolean firstIterationOfJsonValue = true;
            ResultSetMetaData resultSetMetaData = resultSetOriginalQuery.getMetaData();
            int count = resultSetMetaData.getColumnCount();
            if (resultSetOriginalQuery.next()) {
                for (int i = 1; i <= count; ++i) {
                    try {
                        String columnName = resultSetMetaData.getColumnName(i);
                        this.originalHeader.add(columnName);
                        Object value = resultSetOriginalQuery.getObject(columnName);
                        if (!(value instanceof InputStream)) continue;
                        String jsonValue = IOUtils.toString((InputStream)((InputStream)value), (Charset)StandardCharsets.UTF_8);
                        LOG.debug("Column name {} value {}", (Object)columnName, (Object)jsonValue);
                        JsonNode node = mapper.readTree(jsonValue);
                        if (firstIterationOfJsonValue) {
                            firstIterationOfJsonValue = false;
                            this.graphName = node.get("GRAPH_NAME").textValue();
                            this.graphOwner = node.get("GRAPH_OWNER").textValue();
                            this.fillMetadata();
                            this.setSize();
                        }
                        String tableName = node.get("ELEM_TABLE").textValue();
                        this.generateVertexOrEdgeQuery(columnName, tableName);
                        continue;
                    }
                    catch (IOException ex) {
                        LOG.debug("Element is not JSON: {}", (Object)ex.getMessage());
                        throw new IllegalArgumentException(ex);
                    }
                }
            }
        }
    }
}

