/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.graphviz.library.watcher;

import com.google.common.collect.Maps;
import java.time.Duration;
import java.time.Instant;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import oracle.pgx.graphviz.library.watcher.DelayCancellable;
import oracle.pgx.graphviz.library.watcher.Watchdog;
import oracle.pgx.graphviz.library.watcher.WatchdogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Watchdog<T> {
    private static final Logger LOG = LoggerFactory.getLogger(Watchdog.class);
    private final Map<T, Watcher> watcherForKey = Maps.newConcurrentMap();
    private final Instant timeout;
    private final WatchdogManager manager;
    private final int owner;
    private volatile boolean shutdown;

    Watchdog(WatchdogManager manager, int owner) {
        this.manager = manager;
        this.timeout = Instant.ofEpochMilli(Long.MAX_VALUE);
        this.owner = owner;
    }

    Duration timeout() {
        return Duration.ofMillis(this.timeout.toEpochMilli());
    }

    int owner() {
        return this.owner;
    }

    public Watcher enter(String logRecord, T key, AtomicBoolean cancelled) {
        if (this.shutdown) {
            throw new IllegalStateException("Shutting down - cannot run '" + logRecord + "' for " + key);
        }
        cancelled.set(false);
        Watcher result = new Watcher(logRecord, key, Thread.currentThread(), cancelled);
        LOG.debug("Watch {} for '{}'", key, (Object)logRecord);
        this.manager.enqueue(result);
        this.watcherForKey.put(key, result);
        return result;
    }

    public boolean cancel(T key) {
        LOG.info("Explicit cancel {} ", key);
        Watcher watcher = this.watcherForKey.get(key);
        if (watcher == null) {
            LOG.warn("Cancel attempted for nonexistent key {}", key);
        }
        return watcher != null ? watcher.explicitlyCancel() : false;
    }

    public void shutdown() {
        this.shutdown = true;
        HashSet<Watcher> all = new HashSet<Watcher>(this.watcherForKey.values());
        this.watcherForKey.clear();
        all.forEach(w -> w.cancel());
        WatchdogManager.cancelLease(this);
        LOG.info("Shut down watchdog for {} cancelling {} tasks", (Object)this.owner, (Object)all.size());
    }

    public String toString() {
        return "Watchdog {owner=" + this.owner + ", shutdown=" + this.shutdown + "}";
    }

    public final class Watcher
    implements AutoCloseable,
    DelayCancellable {
        final String logRecord;
        final T key;
        final Thread thread;
        private volatile boolean closed;
        private oracle.pgx.graphviz.library.watcher.Watchdog$Watcher.Kill kill;
        private final AtomicBoolean explicitlyCancelled;

        public Watcher(String logRecord, T key, Thread thread, AtomicBoolean explicitlyCancelled) {
            this.logRecord = logRecord;
            this.key = key;
            this.thread = thread;
            this.explicitlyCancelled = explicitlyCancelled;
        }

        @Override
        public boolean timeout() {
            LOG.info("Timeout cancel {} for {}", this.key, (Object)this.logRecord);
            return this.cancel();
        }

        boolean explicitlyCancel() {
            this.explicitlyCancelled.set(true);
            return this.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel() {
            boolean result;
            boolean bl = result = !this.closed;
            if (result) {
                result = !this.thread.isInterrupted();
                this.thread.interrupt();
                Watcher watcher = this;
                synchronized (watcher) {
                    if (this.kill == null) {
                        this.kill = new Kill();
                        Watchdog.this.manager.enqueue((DelayCancellable)this.kill);
                    }
                }
                LOG.info("Cancel {} with result {} for '{}'", new Object[]{this.key, result, this.logRecord});
                return result;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (Watchdog.this.watcherForKey.get(this.key) != this) {
                throw new IllegalArgumentException("Trying to close the wrong interpreter");
            }
            this.closed = true;
            Watchdog.this.manager.dequeue(this);
            Watchdog.this.watcherForKey.remove(this.key);
            oracle.pgx.graphviz.library.watcher.Watchdog$Watcher.Kill k = null;
            Watcher watcher = this;
            synchronized (watcher) {
                k = this.kill;
            }
            if (k != null) {
                Watchdog.this.manager.dequeue((DelayCancellable)k);
            }
            LOG.debug("Stop watching {} for '{}'", this.key, (Object)this.logRecord);
        }

        @Override
        public synchronized long getDelay(TimeUnit unit) {
            return unit.convert(Watchdog.this.timeout.toEpochMilli(), TimeUnit.MILLISECONDS);
        }

        class Kill
        implements DelayCancellable {
            Kill() {
            }

            @Override
            public boolean cancel() {
                boolean result;
                boolean bl = result = !Watcher.this.closed;
                if (result) {
                    LOG.warn("Brutally kill {} for {}", Watcher.this.key, (Object)Watcher.this.logRecord);
                    Watcher.this.thread.stop();
                }
                return result;
            }

            @Override
            public long getDelay(TimeUnit unit) {
                return unit.convert(Watchdog.this.timeout.toEpochMilli(), TimeUnit.MILLISECONDS);
            }
        }
    }
}

