/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.imports.parser.graphson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import oracle.pg.imports.db.Batch;
import oracle.pg.imports.db.ConnectionManager;
import oracle.pg.imports.db.SqlTable;
import oracle.pg.imports.exceptions.GraphImportException;
import oracle.pg.imports.parser.ReaderResult;
import oracle.pg.imports.parser.graphson.Edge;
import oracle.pg.imports.parser.graphson.GraphsonDataTypes;
import oracle.pg.imports.parser.graphson.GraphsonParsedResult;
import oracle.pg.imports.parser.graphson.Vertex;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphsonParser {
    private static final Logger LOG = LoggerFactory.getLogger(GraphsonParser.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private ConnectionManager connectionManager = null;
    private String filePath = null;
    private int batchSize = 1000;
    private int threads = 1;
    private Map<String, SqlTable> vertexTables = new HashMap<String, SqlTable>();
    private Map<String, SqlTable> edgeTables = new HashMap<String, SqlTable>();
    private int stringFieldsSize;
    private short fractionalSecondsPrecision;
    private Map<String, SqlTable> pivotVertexTables = new HashMap<String, SqlTable>();
    private Map<String, SqlTable> pivotEdgeTables = new HashMap<String, SqlTable>();
    private Set<Object> existingEdges = new HashSet<Object>();
    private Set<String> existingTables = ConcurrentHashMap.newKeySet();
    private Map<Object, String> vertexLabels = new HashMap<Object, String>();

    private static JsonNode parseNode(String src) throws JsonProcessingException {
        return objectMapper.readTree(src);
    }

    private static <A> A jsonNodeToClass(JsonNode node, Class<A> clazz) throws JsonProcessingException {
        return (A)objectMapper.treeToValue((TreeNode)node, clazz);
    }

    /*
     * WARNING - void declaration
     */
    public ReaderResult read() throws GraphImportException {
        BasicThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern("graphson-execution-%d").daemon(true).build();
        ExecutorService executorService = Executors.newFixedThreadPool(this.threads, (ThreadFactory)threadFactory);
        LinkedList<Future<Void>> futures = new LinkedList<Future<Void>>();
        int currBatch = 0;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.filePath));){
            void var6_9;
            String string = bufferedReader.readLine();
            while (var6_9 != null) {
                if (currBatch == this.batchSize) {
                    this.persistDataFromPivots();
                    futures.add(executorService.submit(new Batch(this.connectionManager, new GraphsonParsedResult((Map)((Object)SerializationUtils.clone((Serializable)((HashMap)this.pivotVertexTables))), (Map)((Object)SerializationUtils.clone((Serializable)((HashMap)this.pivotEdgeTables)))), this.existingTables, this.stringFieldsSize, this.fractionalSecondsPrecision)));
                    this.pivotVertexTables = new HashMap<String, SqlTable>();
                    this.pivotEdgeTables = new HashMap<String, SqlTable>();
                    currBatch = 0;
                }
                JsonNode node = GraphsonParser.parseNode((String)var6_9);
                Vertex vertex = GraphsonParser.jsonNodeToClass(node, Vertex.class);
                this.processVertex(vertex);
                String string2 = bufferedReader.readLine();
                ++currBatch;
            }
            if (!this.pivotVertexTables.keySet().isEmpty()) {
                this.persistDataFromPivots();
                futures.add(executorService.submit(new Batch(this.connectionManager, new GraphsonParsedResult(this.pivotVertexTables, this.pivotEdgeTables), this.existingTables, this.stringFieldsSize, this.fractionalSecondsPrecision)));
            }
            LOG.debug("Vertex tables: {}", this.vertexTables.keySet());
            LOG.debug("Edge tables: {}", this.edgeTables.keySet());
        }
        catch (IOException e) {
            throw new GraphImportException("Unable to split the file.", e);
        }
        try {
            for (Future future : futures) {
                future.get();
            }
            this.createForeignKeys();
        }
        catch (InterruptedException | SQLException | ExecutionException e) {
            throw new GraphImportException("Failed creating the graph structure and inserting the data.", e);
        }
        return new GraphsonParsedResult(this.vertexTables, this.edgeTables, this.vertexLabels);
    }

    private void createForeignKeys() throws SQLException {
        for (String tableName : this.edgeTables.keySet()) {
            Object sid = this.edgeTables.get(tableName).getData().get(0).get("sid");
            Object did = this.edgeTables.get(tableName).getData().get(0).get("did");
            String sourceLabel = this.vertexLabels.get(sid);
            String destinationLabel = this.vertexLabels.get(did);
            String alterTable = "ALTER TABLE " + tableName + " ADD FOREIGN KEY ( sid ) REFERENCES " + sourceLabel + " ( id )";
            String alterTable2 = "ALTER TABLE " + tableName + " ADD FOREIGN KEY ( did ) REFERENCES " + destinationLabel + " ( id )";
            Connection connection = this.connectionManager.getConnection();
            PreparedStatement stmt = connection.prepareStatement(alterTable);
            stmt.execute();
            stmt = connection.prepareStatement(alterTable2);
            stmt.execute();
        }
    }

    private void persistDataFromPivots() {
        this.copyDataFromOneMapToAnother(this.pivotVertexTables, this.vertexTables);
        this.copyDataFromOneMapToAnother(this.pivotEdgeTables, this.edgeTables);
    }

    private void copyDataFromOneMapToAnother(Map<String, SqlTable> source, Map<String, SqlTable> destination) {
        for (String label : source.keySet()) {
            if (destination.containsKey(label)) continue;
            SqlTable tempSqlTable = new SqlTable(label);
            tempSqlTable.setProperties(source.get(label).getProperties());
            tempSqlTable.addData(source.get(label).getData().get(0));
            destination.put(label, tempSqlTable);
        }
    }

    private void processVertex(Vertex v) throws GraphImportException {
        Map<String, JsonNode> props;
        SqlTable temp;
        String label = v.getLabel();
        GraphsonDataTypes idType = this.getNodeType(v.getId());
        Object idValue = this.getNodeValue(v.getId(), idType);
        if (v.getId().getNodeType().toString().equals("OBJECT") && (label.equals("") || label == null)) {
            String id = v.getId().get("@value").asText();
            throw new GraphImportException(String.format("The vertex with id: %s, does not contain a valid label.", id));
        }
        this.vertexLabels.put(idValue, label);
        if (!this.pivotVertexTables.containsKey(label)) {
            temp = new SqlTable(label);
            props = v.getProperties();
            temp.addProperty("id", idType);
            for (String property : props.keySet()) {
                temp.addProperty(property, this.getVertexPropertyDataType(props.get(property).get(0)));
            }
            this.pivotVertexTables.put(label, temp);
        }
        temp = this.pivotVertexTables.get(label);
        props = v.getProperties();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("id", idValue);
        for (String property : props.keySet()) {
            data.put(property, this.getVertexPropertyDataValue(props.get(property).get(0), temp.getProperties().get(property)));
        }
        this.pivotVertexTables.get(label).addData(data);
        if (v.getInEdges() != null) {
            for (String lab : v.getInEdges().keySet()) {
                for (Edge e : v.getInEdges().get(lab)) {
                    this.processEdge(e, lab, idValue, idType);
                }
            }
        }
        if (v.getOutEdges() != null) {
            for (String lab : v.getOutEdges().keySet()) {
                for (Edge e : v.getOutEdges().get(lab)) {
                    this.processEdge(e, lab, idValue, idType);
                }
            }
        }
    }

    private void processEdge(Edge e, String label, Object vertexId, GraphsonDataTypes vertexIdType) throws GraphImportException {
        Map<String, JsonNode> props;
        SqlTable temp;
        GraphsonDataTypes idType = this.getNodeType(e.getId());
        Object idValue = this.getNodeValue(e.getId(), idType);
        if (this.existingEdges.contains(idValue)) {
            return;
        }
        this.existingEdges.add(idValue);
        if (!this.pivotEdgeTables.containsKey(label)) {
            temp = new SqlTable(label);
            props = e.getProperties();
            temp.addProperty("id", idType);
            if (props != null) {
                for (String string : props.keySet()) {
                    temp.addProperty(string, this.getNodeType(props.get(string)));
                }
            }
            temp.addProperty("sid", vertexIdType);
            temp.addProperty("did", vertexIdType);
            this.pivotEdgeTables.put(label, temp);
        }
        temp = this.pivotEdgeTables.get(label);
        props = e.getProperties();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("id", idValue);
        if (props != null) {
            for (String property : props.keySet()) {
                data.put(property, this.getNodeValue(props.get(property), temp.getProperties().get(property)));
            }
        }
        if (e.getInVertex() != null) {
            GraphsonDataTypes graphsonDataTypes = this.getNodeType(e.getInVertex());
            Object inVDataValue = this.getNodeValue(e.getInVertex(), graphsonDataTypes);
            data.put("sid", vertexId);
            data.put("did", inVDataValue);
        } else if (e.getOutVertex() != null) {
            GraphsonDataTypes graphsonDataTypes = this.getNodeType(e.getOutVertex());
            Object outVDataValue = this.getNodeValue(e.getOutVertex(), graphsonDataTypes);
            data.put("sid", outVDataValue);
            data.put("did", vertexId);
        }
        this.pivotEdgeTables.get(label).addData(data);
    }

    private GraphsonDataTypes convertFromGraphsonToJavaDataType(String graphsonDataType) throws GraphImportException {
        switch (graphsonDataType) {
            case "\"g:Double\"": {
                return GraphsonDataTypes.G_DOUBLE;
            }
            case "\"g:Float\"": {
                return GraphsonDataTypes.G_FLOAT;
            }
            case "\"g:Int32\"": {
                return GraphsonDataTypes.G_INT32;
            }
            case "\"g:Int64\"": {
                return GraphsonDataTypes.G_INT64;
            }
            case "\"g:Date\"": {
                return GraphsonDataTypes.G_DATE;
            }
            case "\"g:Timestamp\"": {
                return GraphsonDataTypes.G_TIMESTAMP;
            }
            case "\"g:UUID\"": {
                return GraphsonDataTypes.G_UUID;
            }
        }
        throw new GraphImportException(String.format("Type %s not supported", graphsonDataType));
    }

    private GraphsonDataTypes getVertexPropertyDataType(JsonNode node) throws GraphImportException {
        String nodeType = node.get("value").getNodeType().toString();
        if (nodeType.equals("OBJECT")) {
            return this.convertFromGraphsonToJavaDataType(node.get("value").get("@type").toString());
        }
        if (nodeType.equals("STRING")) {
            return GraphsonDataTypes.G_STRING;
        }
        throw new GraphImportException(String.format("Type %s not supported, validate that the GraphSON structure and version is correct", nodeType));
    }

    private Object getVertexPropertyDataValue(JsonNode node, GraphsonDataTypes dataType) throws GraphImportException {
        String nodeType = node.get("value").getNodeType().toString();
        JsonNode valueNode = null;
        if (nodeType.equals("OBJECT")) {
            valueNode = node.get("value").get("@value");
        } else if (nodeType.equals("STRING")) {
            valueNode = node.get("value");
        } else {
            throw new GraphImportException(String.format("Type %s not supported", nodeType));
        }
        return this.castJsonNodeToDataType(valueNode, dataType);
    }

    private GraphsonDataTypes getNodeType(JsonNode node) throws GraphImportException {
        String nodeType = node.getNodeType().toString();
        if (nodeType.equals("OBJECT")) {
            return this.convertFromGraphsonToJavaDataType(node.get("@type").toString());
        }
        if (nodeType.equals("STRING")) {
            return GraphsonDataTypes.G_STRING;
        }
        throw new GraphImportException(String.format("Type %s not supported, validate that the GraphSON structure and version is correct", nodeType));
    }

    private Object getNodeValue(JsonNode node, GraphsonDataTypes dataType) throws GraphImportException {
        JsonNode valueNode;
        String nodeType = node.getNodeType().toString();
        if (nodeType.equals("OBJECT")) {
            valueNode = node.get("@value");
        } else if (nodeType.equals("STRING")) {
            valueNode = node;
        } else {
            throw new GraphImportException(String.format("Type %s not supported", nodeType));
        }
        return this.castJsonNodeToDataType(valueNode, dataType);
    }

    private Object castJsonNodeToDataType(JsonNode node, GraphsonDataTypes dataType) throws GraphImportException {
        switch (dataType) {
            case G_DOUBLE: {
                return new Double(node.asDouble());
            }
            case G_FLOAT: {
                return new Float(node.asDouble());
            }
            case G_INT32: {
                return new Integer(node.asInt());
            }
            case G_INT64: {
                return new Long(node.asLong());
            }
            case G_DATE: {
                return new Date(node.asLong());
            }
            case G_TIMESTAMP: {
                return new Timestamp(node.asLong());
            }
            case G_UUID: 
            case G_STRING: {
                return node.asText();
            }
        }
        throw new GraphImportException(String.format("Type %s not supported", new Object[]{dataType}));
    }

    public GraphsonParser setStringFieldsSize(int stringFieldsSize) {
        this.stringFieldsSize = stringFieldsSize;
        return this;
    }

    public GraphsonParser setFractionalSecondsPrecision(short fractionalSecondsPrecision) {
        this.fractionalSecondsPrecision = fractionalSecondsPrecision;
        return this;
    }

    public GraphsonParser setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        return this;
    }

    public GraphsonParser setFilePath(String filePath) {
        this.filePath = filePath;
        return this;
    }

    public GraphsonParser setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public GraphsonParser setThreads(int threads) {
        this.threads = threads;
        return this;
    }

    public GraphsonParser setVertexTables(Map<String, SqlTable> vertexTables) {
        this.vertexTables = vertexTables;
        return this;
    }

    public GraphsonParser setEdgeTables(Map<String, SqlTable> edgeTables) {
        this.edgeTables = edgeTables;
        return this;
    }

    public int getStringFieldsSize() {
        return this.stringFieldsSize;
    }

    public short getFractionalSecondsPrecision() {
        return this.fractionalSecondsPrecision;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getThreads() {
        return this.threads;
    }

    public Map<String, SqlTable> getVertexTables() {
        return this.vertexTables;
    }

    public Map<String, SqlTable> getEdgeTables() {
        return this.edgeTables;
    }
}

