/*
 * Decompiled with CFR 0.152.
 */
package oracle.datastudio.graphviz.formatter.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.google.common.collect.ImmutableMultiset;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import oracle.datastudio.graphviz.formatter.json.Property;

public abstract class Entity {
    @JsonSerialize(using=ToStringSerializer.class)
    @JsonProperty(value="_id")
    public Object id;
    @JsonProperty(value="p")
    public List<Property> properties;
    @JsonProperty(value="l")
    public Set<String> labels;
    @JsonProperty(value="g")
    public Set<String> groups;

    public Entity() {
    }

    Entity(@Nonnull Object id, @Nonnull Set<String> labels, @Nonnull List<Property> properties) {
        this.id = id;
        this.labels = labels;
        this.properties = properties;
        this.groups = new HashSet<String>();
    }

    void addGroup(String group) {
        this.groups.add(group);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Entity that = (Entity)o;
        return this.id.equals(that.id) && ImmutableMultiset.copyOf(this.properties).equals((Object)ImmutableMultiset.copyOf(that.properties)) && Objects.equals(this.labels, that.labels) && Objects.equals(this.groups, that.groups);
    }

    public int hashCode() {
        return Objects.hash(this.id, ImmutableMultiset.copyOf(this.properties), this.labels, this.groups);
    }
}

