/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.jdbc;

import com.google.common.annotations.VisibleForTesting;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import oracle.pg.rdbms.AdbGraphClient;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.ServerInstance;
import oracle.pgx.jdbc.NoopConnection;
import oracle.pgx.jdbc.PgxJdbcDriver;
import oracle.pgx.jdbc.PgxMetaData;
import oracle.pgx.jdbc.PreparedStatementWrapper;
import oracle.pgx.jdbc.StatementWrapper;
import oracle.pgx.jdbc.Util;
import oracle.pgx.jdbc.compat.CompatMode;

class PgxConnection
extends NoopConnection {
    public static final String CONNECTION_PROPERTY_TENANCY_OCID = "tenancy_ocid";
    public static final String CONNECTION_PROPERTY_DATABASE_OCID = "database_ocid";
    public static final String CONNECTION_PROPERTY_DATABASE = "database";
    public static final String CONNECTION_PROPERTY_COMPATIBILITY_MODE = "compat_mode";
    public static final String PGX_COMPATIBILITY_MODE = "pgx";
    public static final String ORACLE_JDBC19_COMPATIBILITY_MODE = "oracle_jdbc19";
    public static final String ORACLE_JDBC23_COMPATIBILITY_MODE = "oracle_jdbc23";
    public static final String CONNECTION_PROPERTY_ADB_ENVIRONMENT_MEMORY = "adbgraphclient_memory";
    public static final String CONNECTION_PROPERTY_STOP_ADB_ENVIRONMENT_UPON_CLOSE = "adbgraphclient_stop_on_close";
    private final PgxJdbcDriver driver;
    private final String url;
    private final String userName;
    private final ServerInstance instance;
    private final PgxSession session;
    private CompatMode compat;
    private AdbGraphClient client;
    private boolean stopEnvUponClose = false;
    private boolean closed = false;

    PgxConnection(PgxJdbcDriver driver, String url, String userName, ServerInstance instance, PgxSession session) {
        this.driver = driver;
        this.url = url;
        this.userName = userName;
        this.instance = instance;
        this.session = session;
    }

    void setCompatMode(CompatMode compat) {
        this.compat = compat;
    }

    void setAdbGraphClient(AdbGraphClient client) {
        this.client = client;
    }

    void setStopEnvUponClose(boolean stopEnvUponClose) {
        this.stopEnvUponClose = stopEnvUponClose;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return Util.invokePgxApi(() -> {
            String serverVersion = this.instance.getVersion().getReleaseVersion();
            String[] serverVersionParts = serverVersion.split("\\.");
            int serverMajor = Integer.parseInt(serverVersionParts[0]);
            int serverMinor = Integer.parseInt(serverVersionParts[1]);
            return new PgxMetaData(this, this.url, this.userName, serverMajor, serverMinor);
        });
    }

    @VisibleForTesting
    PgxJdbcDriver getDriver() {
        return this.driver;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == AdbGraphClient.class && this.client != null) {
            return iface.cast(this.client);
        }
        if (iface == ServerInstance.class) {
            return iface.cast(this.instance);
        }
        if (iface == PgxSession.class) {
            return iface.cast(this.session);
        }
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface == PgxSession.class || iface == ServerInstance.class) {
            return true;
        }
        return this.client != null && iface == AdbGraphClient.class;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new StatementWrapper(this, this.session, this.compat);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return Util.invokePgxApi(() -> new PreparedStatementWrapper(this, this.session, this.session.preparePgql(sql), this.compat));
    }

    @Override
    public void close() throws SQLException {
        Util.invokePgxApi(() -> {
            this.session.close();
            if (this.client != null && this.stopEnvUponClose && this.client.isAttached()) {
                this.client.stopEnvironment();
            }
            return null;
        });
        this.closed = true;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

