/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alink.python.util;

import com.alibaba.alink.common.lazy.ExtractModelInfoBatchOp;
import com.alibaba.alink.common.lazy.HasLazyPrintModelInfo;
import com.alibaba.alink.common.lazy.HasLazyPrintTrainInfo;
import com.alibaba.alink.common.lazy.WithModelInfoBatchOp;
import com.alibaba.alink.common.lazy.WithTrainInfo;
import com.alibaba.alink.executor.util.StreamOpUtil;
import com.alibaba.alink.operator.AlgoOperator;
import com.alibaba.alink.operator.batch.BatchOperator;
import com.alibaba.alink.operator.batch.dataproc.SplitBatchOp;
import com.alibaba.alink.operator.batch.sink.BaseSinkBatchOp;
import com.alibaba.alink.operator.batch.source.BaseSourceBatchOp;
import com.alibaba.alink.operator.batch.source.DataSetWrapperBatchOp;
import com.alibaba.alink.operator.batch.source.MemSourceBatchOp;
import com.alibaba.alink.operator.batch.source.NumSeqSourceBatchOp;
import com.alibaba.alink.operator.batch.source.TableSourceBatchOp;
import com.alibaba.alink.operator.batch.utils.UDFBatchOp;
import com.alibaba.alink.operator.batch.utils.UDTFBatchOp;
import com.alibaba.alink.operator.batch.utils.VectorSerializeBatchOp;
import com.alibaba.alink.operator.stream.StreamOperator;
import com.alibaba.alink.operator.stream.sink.BaseSinkStreamOp;
import com.alibaba.alink.operator.stream.source.BaseSourceStreamOp;
import com.alibaba.alink.operator.stream.source.MemSourceStreamOp;
import com.alibaba.alink.operator.stream.source.NumSeqSourceStreamOp;
import com.alibaba.alink.operator.stream.source.TableSourceStreamOp;
import com.alibaba.alink.operator.stream.utils.UDFStreamOp;
import com.alibaba.alink.operator.stream.utils.UDTFStreamOp;
import com.alibaba.alink.operator.stream.utils.VectorSerializeStreamOp;
import com.alibaba.alink.params.shared.HasMLEnvironmentId;
import com.alibaba.alink.pipeline.LocalPredictable;
import com.alibaba.alink.pipeline.ModelBase;
import com.alibaba.alink.pipeline.Pipeline;
import com.alibaba.alink.pipeline.PipelineModel;
import com.alibaba.alink.pipeline.PipelineStageBase;
import com.alibaba.alink.pipeline.TransformerBase;
import com.alibaba.alink.pipeline.feature.PCA;
import com.alibaba.alink.pipeline.tuning.BaseGridSearch;
import com.alibaba.alink.pipeline.tuning.BaseRandomSearch;
import com.alibaba.alink.pipeline.tuning.TuningEvaluator;
import com.alibaba.alink.python.util.ParamUtil;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.ml.api.misc.param.ParamInfo;

public class GeneratePyOp {
    static Map<String, Set<String>> NAME_MAPPING = new HashMap<String, Set<String>>();
    static Set<String> IGNORE_OP_SET = new HashSet<String>();
    final Class cls;
    static int MAX_CLASS_ONE_FILE = 0x10000000;
    static final List<Class<?>> INTERFACE_CANDIDATES = Arrays.asList(WithModelInfoBatchOp.class, WithTrainInfo.class, ExtractModelInfoBatchOp.class, HasLazyPrintModelInfo.class, HasLazyPrintTrainInfo.class, LocalPredictable.class);

    public GeneratePyOp(Class<? extends AlgoOperator> cls) {
        this.cls = cls;
    }

    static String calcOpType(Class cls) {
        if (BaseSourceBatchOp.class.isAssignableFrom(cls) || BaseSourceStreamOp.class.isAssignableFrom(cls) || MemSourceBatchOp.class.equals((Object)cls) || NumSeqSourceBatchOp.class.equals((Object)cls) || MemSourceStreamOp.class.equals((Object)cls)) {
            return "SOURCE";
        }
        if (BaseSinkBatchOp.class.isAssignableFrom(cls) || BaseSinkStreamOp.class.isAssignableFrom(cls)) {
            return "SINK";
        }
        return "FUNCTION";
    }

    static String calcBasePyCls(Class cls) {
        if (StreamOperator.class.isAssignableFrom(cls)) {
            try {
                if (StreamOpUtil.checkHasModel(cls.getName())) {
                    return "BaseModelStreamOp";
                }
                if (BaseSinkStreamOp.class.isAssignableFrom(cls)) {
                    return "BaseSinkStreamOp";
                }
                return "StreamOperator";
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (BatchOperator.class.isAssignableFrom(cls)) {
            if (BaseSinkBatchOp.class.isAssignableFrom(cls)) {
                return "BaseSinkBatchOp";
            }
            return "BatchOperator";
        }
        if (TuningEvaluator.class.isAssignableFrom(cls)) {
            return "TuningEvaluator";
        }
        if (BaseGridSearch.class.isAssignableFrom(cls)) {
            return "BaseGridSearch";
        }
        if (BaseRandomSearch.class.isAssignableFrom(cls)) {
            return "BaseRandomSearch";
        }
        if (ModelBase.class.isAssignableFrom(cls)) {
            return "Model";
        }
        if (TransformerBase.class.isAssignableFrom(cls)) {
            return "Transformer";
        }
        return "Estimator";
    }

    static List<String> calcBasePyInterfaces(Class cls) {
        return INTERFACE_CANDIDATES.stream().filter(d -> d.isAssignableFrom(cls)).map(Class::getSimpleName).collect(Collectors.toList());
    }

    static String formatParamName(String name) {
        return StringUtils.capitalize((String)name);
    }

    static String makeClassMethod(ParamInfo info) {
        StringBuilder sb = new StringBuilder();
        sb.append("    def set").append(GeneratePyOp.formatParamName(info.getName())).append("(self, val):\n");
        sb.append("        return self._add_param('").append(info.getName()).append("', val)\n");
        return sb.toString();
    }

    static String calc(Class cls, String name) {
        List paramList = ParamUtil.getParametersByOperator(cls).stream().filter(d -> !d.getName().startsWith("lazyPrint")).collect(Collectors.toList());
        StringBuilder sb = new StringBuilder();
        String basePyCls = GeneratePyOp.calcBasePyCls(cls);
        List<String> basePyInterfaces = GeneratePyOp.calcBasePyInterfaces(cls);
        basePyInterfaces.add(0, basePyCls);
        String clsName = name;
        sb.append("class ").append(clsName).append("(").append(String.join((CharSequence)", ", basePyInterfaces)).append("):").append("\n");
        sb.append("    CLS_NAME = '").append(cls.getName()).append("'\n");
        sb.append("    OP_TYPE = '").append(GeneratePyOp.calcOpType(cls)).append("'\n");
        sb.append("\n");
        sb.append("    def __init__(self, *args, **kwargs):").append("\n");
        sb.append("        kwargs['CLS_NAME'] = self.CLS_NAME\n");
        sb.append("        kwargs['OP_TYPE'] = self.OP_TYPE\n");
        sb.append("        super(").append(clsName).append(", self).__init__(*args, **kwargs)").append("\n");
        sb.append("        pass").append("\n");
        HashSet<String> names = new HashSet<String>();
        for (ParamInfo info : paramList) {
            if (names.contains(info.getName()) || HasMLEnvironmentId.ML_ENVIRONMENT_ID.equals(info)) continue;
            names.add(info.getName());
            sb.append("\n");
            sb.append(GeneratePyOp.makeClassMethod(info));
        }
        return sb.toString();
    }

    static void initNameMapping() {
        GeneratePyOp.addEntry("com.alibaba.alink.pipeline.dataproc.vector.KvToVectorBatchOp", "KvToTensorBatchOp");
        GeneratePyOp.addEntry("com.alibaba.alink.pipeline.dataproc.vector.VectorToColumnsBatchOp", "TensorToTableBatchOp");
        GeneratePyOp.addEntry("com.alibaba.alink.operator.batch.outlier.BoxPlotTrainBatchOp", "BoxPlotBatchOp");
        GeneratePyOp.addEntry("com.alibaba.alink.operator.batch.outlier.IsolationForestsTrainBatchOp", "IsolationForestsBatchOp");
        GeneratePyOp.addEntry("com.alibaba.alink.operator.batch.ml.classification.LogisticRegressionTrainBatchOp", "LogistRegTrainBatchOp");
        GeneratePyOp.addEntry("com.alibaba.alink.operator.batch.ml.classification.LogisticRegressionPredictBatchOp", "LogistRegPredictBatchOp");
        GeneratePyOp.addEntry("com.alibaba.alink.operator.stream.ml.classification LogisticRegressionPredictStreamOp", "LogistRegPredictStreamOp");
    }

    static void initIgnoreOpSet() {
        Consumer<Class> f = x -> IGNORE_OP_SET.add(x.getName());
        f.accept(BaseSinkStreamOp.class);
        f.accept(BaseSinkBatchOp.class);
        f.accept(BaseSourceStreamOp.class);
        f.accept(BaseSourceBatchOp.class);
        f.accept(MemSourceBatchOp.class);
        f.accept(MemSourceStreamOp.class);
        f.accept(NumSeqSourceBatchOp.class);
        f.accept(NumSeqSourceStreamOp.class);
        f.accept(TableSourceStreamOp.class);
        f.accept(DataSetWrapperBatchOp.class);
        f.accept(UDFBatchOp.class);
        f.accept(UDTFBatchOp.class);
        f.accept(UDFStreamOp.class);
        f.accept(UDTFStreamOp.class);
        f.accept(VectorSerializeBatchOp.class);
        f.accept(VectorSerializeStreamOp.class);
        f.accept(ModelBase.class);
        f.accept(PipelineModel.class);
        f.accept(TableSourceBatchOp.class);
        IGNORE_OP_SET.add("com.alibaba.alink.executor.common.AddMetricBatchOp");
        IGNORE_OP_SET.add("com.alibaba.alink.executor.common.AddMetricStreamOp");
        IGNORE_OP_SET.add("com.alibaba.alink.executor.common.AddProcTimeStreamOp");
        IGNORE_OP_SET.add("com.alibaba.alink.executor.common.DynamicElasticSearchSinkStreamOp");
        IGNORE_OP_SET.add("com.alibaba.alink.executor.common.EraseProcTimeAttrStreamOp");
        IGNORE_OP_SET.add("com.alibaba.alink.executor.common.MergeStreamOp");
        IGNORE_OP_SET.add("com.alibaba.alink.io.DataHubDB$DataHubSourceStreamOp");
        IGNORE_OP_SET.add("com.alibaba.alink.io.DataHubDB$DataHubSinkStreamOp");
        IGNORE_OP_SET.add("com.alibaba.alink.operator.batch.BatchOperator$MemSinkBatchOp");
    }

    static void addEntry(String clsName, String newName) {
        Set h = NAME_MAPPING.computeIfAbsent(clsName, x -> new HashSet());
        h.add(newName);
        NAME_MAPPING.put(clsName, h);
    }

    static boolean isNewOp(Class<?> cls) {
        if (Modifier.isAbstract(cls.getModifiers())) {
            return false;
        }
        if (cls.getTypeParameters().length > 0) {
            return false;
        }
        return !IGNORE_OP_SET.contains(cls.getName());
    }

    static void writeSingleBatchFile(List<Class<?>> batchOpList, String filename) throws FileNotFoundException, UnsupportedEncodingException {
        PrintStream ps = new PrintStream((OutputStream)new FileOutputStream(new File(filename)), true, "utf-8");
        ps.println("#!/usr/bin/env python");
        ps.println("# -*- coding: utf-8 -*-");
        ps.println();
        ps.println("from ..base import BatchOperator, BaseSinkBatchOp");
        ps.println("from ..lazy.extract_model_info_batch_op import ExtractModelInfoBatchOp");
        ps.println("from ..lazy.with_model_info_batch_op import WithModelInfoBatchOp");
        ps.println("from ..lazy.with_train_info import WithTrainInfo");
        ps.println();
        batchOpList.stream().filter(GeneratePyOp::isNewOp).sorted((a, b) -> a.getSimpleName().compareTo(b.getSimpleName())).forEach(cls -> {
            ps.println();
            ps.println(GeneratePyOp.calc(cls, cls.getSimpleName()));
            if (NAME_MAPPING.containsKey(cls.getName())) {
                for (String name : NAME_MAPPING.get(cls.getName())) {
                    ps.println();
                    ps.println(GeneratePyOp.calc(cls, name));
                }
            }
        });
        ps.flush();
        IOUtils.closeQuietly((OutputStream)ps);
    }

    static void runBatch(String folder) throws IOException {
        List all = GeneratePyOp.listSubtypeClasses(BatchOperator.class).stream().filter(GeneratePyOp::isNewOp).sorted((a, b) -> a.getSimpleName().compareTo(b.getSimpleName())).collect(Collectors.toList());
        StringBuilder sb = new StringBuilder();
        sb.append("# -*- coding: utf-8 -*-\n\n");
        int idx = 0;
        for (int i = 0; i < all.size(); i += MAX_CLASS_ONE_FILE) {
            String rawName = "batch_op_" + ++idx;
            sb.append("from .").append(rawName).append(" import *\n");
            String filename = Paths.get(folder, rawName + ".py").toFile().getAbsolutePath();
            GeneratePyOp.writeSingleBatchFile(all.subList(i, Math.min(i + MAX_CLASS_ONE_FILE, all.size())), filename);
        }
        Files.write(Paths.get(folder, "__init__.py"), sb.toString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    static void writeSingleStreamFile(List<Class<?>> streamOpList, String filename) throws IOException {
        PrintStream ps = new PrintStream((OutputStream)new FileOutputStream(new File(filename)), true, "utf-8");
        ps.println("#!/usr/bin/env python");
        ps.println("# -*- coding: utf-8 -*-");
        ps.println();
        ps.println("from ..base import StreamOperator, BaseSinkStreamOp, BaseModelStreamOp");
        ps.println();
        streamOpList.stream().filter(GeneratePyOp::isNewOp).sorted((a, b) -> a.getSimpleName().compareTo(b.getSimpleName())).forEach(cls -> {
            ps.println();
            ps.println(GeneratePyOp.calc(cls, cls.getSimpleName()));
            if (NAME_MAPPING.containsKey(cls.getName())) {
                for (String name : NAME_MAPPING.get(cls.getName())) {
                    ps.println();
                    ps.println(GeneratePyOp.calc(cls, name));
                }
            }
        });
        ps.flush();
        IOUtils.closeQuietly((OutputStream)ps);
    }

    static void runStream(String folder) throws IOException {
        List all = GeneratePyOp.listSubtypeClasses(StreamOperator.class).stream().filter(GeneratePyOp::isNewOp).sorted((a, b) -> a.getSimpleName().compareTo(b.getSimpleName())).collect(Collectors.toList());
        StringBuilder sb = new StringBuilder();
        sb.append("# -*- coding: utf-8 -*-\n\n");
        int idx = 0;
        for (int i = 0; i < all.size(); i += MAX_CLASS_ONE_FILE) {
            String rawName = "stream_op_" + ++idx;
            sb.append("from .").append(rawName).append(" import *\n");
            String filename = Paths.get(folder, rawName + ".py").toFile().getAbsolutePath();
            GeneratePyOp.writeSingleStreamFile(all.subList(i, Math.min(i + MAX_CLASS_ONE_FILE, all.size())), filename);
        }
        Files.write(Paths.get(folder, "__init__.py"), sb.toString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    static void writeSinglePipelineFile(List<Class<?>> streamOpList, String filename) throws IOException {
        PrintStream ps = new PrintStream((OutputStream)new FileOutputStream(new File(filename)), true, "utf-8");
        ps.println("#!/usr/bin/env python");
        ps.println("# -*- coding: utf-8 -*-");
        ps.println();
        ps.println("from ..base import Estimator, Transformer, Model, TuningEvaluator");
        ps.println("from ..tuning.base import BaseGridSearch, BaseRandomSearch");
        ps.println("from ..lazy.has_lazy_print_model_info import HasLazyPrintModelInfo");
        ps.println("from ..lazy.has_lazy_print_train_info import HasLazyPrintTrainInfo");
        ps.println("from ..local_predictor import LocalPredictable");
        ps.println();
        streamOpList.stream().filter(GeneratePyOp::isNewOp).sorted((a, b) -> a.getSimpleName().compareTo(b.getSimpleName())).forEach(cls -> {
            ps.println();
            ps.println(GeneratePyOp.calc(cls, cls.getSimpleName()));
            if (NAME_MAPPING.containsKey(cls.getName())) {
                for (String name : NAME_MAPPING.get(cls.getName())) {
                    ps.println();
                    ps.println(GeneratePyOp.calc(cls, name));
                }
            }
        });
        ps.flush();
        IOUtils.closeQuietly((OutputStream)ps);
    }

    static void runPipeline(String folder) throws IOException {
        List<Class> skippedClass = Arrays.asList(Pipeline.class);
        List all = GeneratePyOp.listSubtypeClasses(PipelineStageBase.class, TuningEvaluator.class).stream().filter(GeneratePyOp::isNewOp).filter(d -> !skippedClass.contains(d)).sorted((a, b) -> a.getSimpleName().compareTo(b.getSimpleName())).collect(Collectors.toList());
        StringBuilder sb = new StringBuilder();
        sb.append("# -*- coding: utf-8 -*-\n\n");
        int idx = 0;
        for (int i = 0; i < all.size(); i += MAX_CLASS_ONE_FILE) {
            String rawName = "pipeline_op_" + ++idx;
            sb.append("from .").append(rawName).append(" import *\n");
            String filename = Paths.get(folder, rawName + ".py").toFile().getAbsolutePath();
            GeneratePyOp.writeSinglePipelineFile(all.subList(i, Math.min(i + MAX_CLASS_ONE_FILE, all.size())), filename);
        }
        Files.write(Paths.get(folder, "__init__.py"), sb.toString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    static List<Class<?>> listSubtypeClasses(Class baseCls) {
        try (ScanResult res = new ClassGraph().enableAllInfo().whitelistPackages("com.alibaba.alink").scan();){
            ClassInfoList infoList = res.getSubclasses(baseCls.getName());
            List<Class<?>> list = infoList.loadClasses();
            return list;
        }
    }

    static List<Class<?>> listSubtypeClasses(Class ... baseClasses) {
        ArrayList ret = new ArrayList();
        for (Class cls : baseClasses) {
            try (ScanResult res = new ClassGraph().enableAllInfo().whitelistPackages("com.alibaba.alink").scan();){
                ClassInfoList infoList = res.getSubclasses(cls.getName());
                ret.addAll(infoList.loadClasses());
            }
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            GeneratePyOp.initIgnoreOpSet();
            GeneratePyOp.initNameMapping();
            if (args.length <= 2) throw new RuntimeException("Missing MaxNumClassesOneFile");
            MAX_CLASS_ONE_FILE = Integer.parseInt(args[2]);
            if (args[0].equalsIgnoreCase("stream")) {
                GeneratePyOp.runStream(args[1]);
                return;
            } else if (args[0].equalsIgnoreCase("batch")) {
                GeneratePyOp.runBatch(args[1]);
                return;
            } else {
                GeneratePyOp.runPipeline(args[1]);
            }
            return;
        } else {
            System.out.println(GeneratePyOp.calc(SplitBatchOp.class, "SplitBatchOp"));
            System.out.println();
            System.out.println(GeneratePyOp.calc(PCA.class, "PCA"));
        }
    }
}

