# mypy-boto3-kafka<a id="mypy-boto3-kafka"></a>

[![PyPI - mypy-boto3-kafka](https://img.shields.io/pypi/v/mypy-boto3-kafka.svg?color=blue)](https://pypi.org/project/mypy-boto3-kafka)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-kafka.svg?color=blue)](https://pypi.org/project/mypy-boto3-kafka)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-kafka?color=blue)](https://pypistats.org/packages/mypy-boto3-kafka)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.Kafka 1.17.75](https://boto3.amazonaws.com/v1/documentation/api/1.17.75/reference/services/kafka.html#Kafka)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.13.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-kafka docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_kafka/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-kafka](#mypy-boto3-kafka)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

## How to install<a id="how-to-install"></a>

Install `boto3-stubs` for `Kafka` service.

```bash
python -m pip install boto3-stubs[kafka]
```

## Usage<a id="usage"></a>

### VSCode<a id="vscode"></a>

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[kafka]` in your environment:
  `python -m pip install 'boto3-stubs[kafka]'`

Both type checking and auto-complete should work for `Kafka` service. No
explicit type annotations required, write your `boto3` code as usual.

### PyCharm<a id="pycharm"></a>

- Install `boto-stubs[kafka]` in your environment:
  `python -m pip install 'boto3-stubs[kafka]'`

Both type checking and auto-complete should work for `Kafka` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

### Other IDEs<a id="other-ides"></a>

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

### mypy<a id="mypy"></a>

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[kafka]` in your environment:
  `python -m pip install 'boto3-stubs[kafka]'`
- Run `mypy` as usual

Type checking should work for `Kafka` service. No explicit type annotations
required, write your `boto3` code as usual.

### pyright<a id="pyright"></a>

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[kafka]` in your environment:
  `python -m pip install 'boto3-stubs[kafka]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `Kafka` service. No explicit type annotations
required, write your `boto3` code as usual.

## Explicit type annotations<a id="explicit-type-annotations"></a>

### Client annotations<a id="client-annotations"></a>

`KafkaClient` provides annotations for `boto3.client("kafka")`.

```python
import boto3

from mypy_boto3_kafka import KafkaClient

client: KafkaClient = boto3.client("kafka")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: KafkaClient = session.client("kafka")
```

### Paginators annotations<a id="paginators-annotations"></a>

`mypy_boto3_kafka.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_kafka import KafkaClient
from mypy_boto3_kafka.paginator import (
    ListClusterOperationsPaginator,
    ListClustersPaginator,
    ListConfigurationRevisionsPaginator,
    ListConfigurationsPaginator,
    ListKafkaVersionsPaginator,
    ListNodesPaginator,
    ListScramSecretsPaginator,
)

client: KafkaClient = boto3.client("kafka")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_cluster_operations_paginator: ListClusterOperationsPaginator = client.get_paginator("list_cluster_operations")
list_clusters_paginator: ListClustersPaginator = client.get_paginator("list_clusters")
list_configuration_revisions_paginator: ListConfigurationRevisionsPaginator = client.get_paginator("list_configuration_revisions")
list_configurations_paginator: ListConfigurationsPaginator = client.get_paginator("list_configurations")
list_kafka_versions_paginator: ListKafkaVersionsPaginator = client.get_paginator("list_kafka_versions")
list_nodes_paginator: ListNodesPaginator = client.get_paginator("list_nodes")
list_scram_secrets_paginator: ListScramSecretsPaginator = client.get_paginator("list_scram_secrets")
```

### Literals<a id="literals"></a>

`mypy_boto3_kafka.literals` module contains literals extracted from shapes that
can be used in user code for type checking.

```python
from mypy_boto3_kafka.literals import (
    BrokerAZDistributionType,
    ClientBrokerType,
    ClusterStateType,
    ConfigurationStateType,
    EnhancedMonitoringType,
    KafkaVersionStatusType,
    ListClusterOperationsPaginatorName,
    ListClustersPaginatorName,
    ListConfigurationRevisionsPaginatorName,
    ListConfigurationsPaginatorName,
    ListKafkaVersionsPaginatorName,
    ListNodesPaginatorName,
    ListScramSecretsPaginatorName,
    NodeTypeType,
)

def check_value(value: BrokerAZDistributionType) -> bool:
    ...
```

### Typed dictionaries<a id="typed-dictionaries"></a>

`mypy_boto3_kafka.type_defs` module contains structures and shapes assembled to
typed dictionaries for additional type checking.

```python
from mypy_boto3_kafka.type_defs import (
    BatchAssociateScramSecretResponseTypeDef,
    BatchDisassociateScramSecretResponseTypeDef,
    BrokerEBSVolumeInfoTypeDef,
    BrokerLogsTypeDef,
    BrokerNodeGroupInfoTypeDef,
    BrokerNodeInfoTypeDef,
    BrokerSoftwareInfoTypeDef,
    ClientAuthenticationTypeDef,
    CloudWatchLogsTypeDef,
    ClusterInfoTypeDef,
    ClusterOperationInfoTypeDef,
    ClusterOperationStepInfoTypeDef,
    ClusterOperationStepTypeDef,
    CompatibleKafkaVersionTypeDef,
    ConfigurationInfoTypeDef,
    ConfigurationRevisionTypeDef,
    ConfigurationTypeDef,
    CreateClusterResponseTypeDef,
    CreateConfigurationResponseTypeDef,
    DeleteClusterResponseTypeDef,
    DeleteConfigurationResponseTypeDef,
    DescribeClusterOperationResponseTypeDef,
    DescribeClusterResponseTypeDef,
    DescribeConfigurationResponseTypeDef,
    DescribeConfigurationRevisionResponseTypeDef,
    EBSStorageInfoTypeDef,
    EncryptionAtRestTypeDef,
    EncryptionInTransitTypeDef,
    EncryptionInfoTypeDef,
    ErrorInfoTypeDef,
    FirehoseTypeDef,
    GetBootstrapBrokersResponseTypeDef,
    GetCompatibleKafkaVersionsResponseTypeDef,
    IamTypeDef,
    JmxExporterInfoTypeDef,
    JmxExporterTypeDef,
    KafkaVersionTypeDef,
    ListClusterOperationsResponseTypeDef,
    ListClustersResponseTypeDef,
    ListConfigurationRevisionsResponseTypeDef,
    ListConfigurationsResponseTypeDef,
    ListKafkaVersionsResponseTypeDef,
    ListNodesResponseTypeDef,
    ListScramSecretsResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    LoggingInfoTypeDef,
    MutableClusterInfoTypeDef,
    NodeExporterInfoTypeDef,
    NodeExporterTypeDef,
    NodeInfoTypeDef,
    OpenMonitoringInfoTypeDef,
    OpenMonitoringTypeDef,
    PaginatorConfigTypeDef,
    PrometheusInfoTypeDef,
    PrometheusTypeDef,
    RebootBrokerResponseTypeDef,
    S3TypeDef,
    SaslTypeDef,
    ScramTypeDef,
    StateInfoTypeDef,
    StorageInfoTypeDef,
    TlsTypeDef,
    UnprocessedScramSecretTypeDef,
    UpdateBrokerCountResponseTypeDef,
    UpdateBrokerStorageResponseTypeDef,
    UpdateBrokerTypeResponseTypeDef,
    UpdateClusterConfigurationResponseTypeDef,
    UpdateClusterKafkaVersionResponseTypeDef,
    UpdateConfigurationResponseTypeDef,
    UpdateMonitoringResponseTypeDef,
    ZookeeperNodeInfoTypeDef,
)

def get_structure() -> BatchAssociateScramSecretResponseTypeDef:
    return {
      ...
    }
```

## Versioning<a id="versioning"></a>

`mypy-boto3-kafka` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

## Documentation<a id="documentation"></a>

All type annotations can be found in
[mypy-boto3-kafka docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_kafka/)

## Support and contributing<a id="support-and-contributing"></a>

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
