# Singularity Python

[![Build Status](https://travis-ci.org/singularityhub/singularity-cli.svg?branch=master)](https://travis-ci.org/singularityhub/singularity-cli)
[![GitHub actions status](https://github.com/singularityhub/singularity-cli/workflows/spython-ci/badge.svg?branch=master)](https://github.com/singularityhub/singularity-cli/actions?query=branch%3Amaster+workflow%3Aspython-ci)

Singularity Python (spython) is the Python API for working with <a href="https://sylabs.io/guides/latest/user-guide/" target="_blank">Singularity</a> containers. See
the [documentation](https://singularityhub.github.io/singularity-cli) for installation and usage, and
the [install instructions](https://singularityhub.github.io/singularity-cli/install) for a quick start.

We provide a [Singularity](Singularity) recipe for you to use if more convenient, along with the [full modules docstring](https://singularityhub.github.io/singularity-cli/api/source/spython.main.base.html#module-spython.main.base).

As of version 0.1.0, we only support Singularity > 3.5.2. This is done to encourage using
newer versions of Singularity with security fixes. If you want to use an older version of Singularity,
you will need to use version 0.0.85 or earlier.

## 😁️ Contributors 😁️

We use the [all-contributors](https://github.com/all-contributors/all-contributors) 
tool to generate a contributors graphic below.

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

 

## License

This code is licensed under the MPL 2.0 [LICENSE](LICENSE).

## Help and Contribution

Please contribute to the package, or post feedback and questions as <a href="https://github.com/singularityhub/singularity-cli" target="_blank">issues</a>. For points that require discussion of the larger group, please use the <a href="https://groups.google.com/a/lbl.gov/forum/#!forum/singularity" target="_blank">Singularity List</a>
