# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['LinkArgs', 'Link']

@pulumi.input_type
class LinkArgs:
    def __init__(__self__, *,
                 from_cluster_kubeconfig: pulumi.Input[str],
                 from_cluster_name: pulumi.Input[str]):
        """
        The set of arguments for constructing a Link resource.
        :param pulumi.Input[str] from_cluster_kubeconfig: Kubernetes config file that provides access credentials to the cluster whose services should be mirrored.
        :param pulumi.Input[str] from_cluster_name: Name of the cluster whose services should be mirrored.
        """
        pulumi.set(__self__, "from_cluster_kubeconfig", from_cluster_kubeconfig)
        pulumi.set(__self__, "from_cluster_name", from_cluster_name)

    @property
    @pulumi.getter
    def from_cluster_kubeconfig(self) -> pulumi.Input[str]:
        """
        Kubernetes config file that provides access credentials to the cluster whose services should be mirrored.
        """
        return pulumi.get(self, "from_cluster_kubeconfig")

    @from_cluster_kubeconfig.setter
    def from_cluster_kubeconfig(self, value: pulumi.Input[str]):
        pulumi.set(self, "from_cluster_kubeconfig", value)

    @property
    @pulumi.getter
    def from_cluster_name(self) -> pulumi.Input[str]:
        """
        Name of the cluster whose services should be mirrored.
        """
        return pulumi.get(self, "from_cluster_name")

    @from_cluster_name.setter
    def from_cluster_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "from_cluster_name", value)


class Link(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 from_cluster_kubeconfig: Optional[pulumi.Input[str]] = None,
                 from_cluster_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Links the services from one cluster into another cluster.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] from_cluster_kubeconfig: Kubernetes config file that provides access credentials to the cluster whose services should be mirrored.
        :param pulumi.Input[str] from_cluster_name: Name of the cluster whose services should be mirrored.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LinkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Links the services from one cluster into another cluster.

        :param str resource_name: The name of the resource.
        :param LinkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LinkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 from_cluster_kubeconfig: Optional[pulumi.Input[str]] = None,
                 from_cluster_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LinkArgs.__new__(LinkArgs)

            if from_cluster_kubeconfig is None and not opts.urn:
                raise TypeError("Missing required property 'from_cluster_kubeconfig'")
            __props__.__dict__["from_cluster_kubeconfig"] = from_cluster_kubeconfig
            if from_cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'from_cluster_name'")
            __props__.__dict__["from_cluster_name"] = from_cluster_name
            __props__.__dict__["config_group_yaml"] = None
        super(Link, __self__).__init__(
            'linkerd-link:index:Link',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Link':
        """
        Get an existing Link resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = LinkArgs.__new__(LinkArgs)

        __props__.__dict__["config_group_yaml"] = None
        __props__.__dict__["from_cluster_kubeconfig"] = None
        __props__.__dict__["from_cluster_name"] = None
        return Link(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def config_group_yaml(self) -> pulumi.Output[str]:
        """
        YAML output that can be applied to the destination cluster (into wich the resources should be mirrored) with k8s.yaml.ConfigGroup.
        """
        return pulumi.get(self, "config_group_yaml")

    @property
    @pulumi.getter
    def from_cluster_kubeconfig(self) -> pulumi.Output[str]:
        """
        Kubernetes config file that provides access credentials to the cluster whose services should be mirrored.
        """
        return pulumi.get(self, "from_cluster_kubeconfig")

    @property
    @pulumi.getter
    def from_cluster_name(self) -> pulumi.Output[str]:
        """
        Name of the cluster whose services should be mirrored.
        """
        return pulumi.get(self, "from_cluster_name")

